/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.SecureSessionUdp;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.TunnelCRI;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

final class SecureTunnelUdp
extends KNXnetIPTunnel {
    private final SecureSessionUdp udp;

    SecureTunnelUdp(KNXnetIPTunnel.TunnelingLayer knxLayer, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNAT, IndividualAddress tunnelingAddress, SecureSessionUdp udp) throws KNXException, InterruptedException {
        super(knxLayer, serverCtrlEP);
        this.udp = udp;
        TunnelCRI cri = tunnelingAddress.equals(KNXMediumSettings.BackboneRouter) ? new TunnelCRI(knxLayer) : new TunnelCRI(knxLayer, tunnelingAddress);
        this.connect(localEP, serverCtrlEP, cri, useNAT);
    }

    @Override
    protected void connect(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, CRI cri, boolean useNAT) throws KNXException, InterruptedException {
        InetSocketAddress local = Net.matchRemoteEndpoint(localEP, serverCtrlEP, useNAT);
        this.udp.setupSecureSession(this, local, serverCtrlEP, useNAT);
        super.connect(local, serverCtrlEP, cri, useNAT);
    }

    @Override
    public String name() {
        return "KNX/IP " + SecureConnection.secureSymbol + " Tunneling " + Net.hostPort(this.ctrlEndpt);
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        byte[] wrapped = this.udp.newSecurePacket(packet);
        super.send(wrapped, dst);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        int svc = h.getServiceType();
        if (!h.isSecure()) {
            this.logger.trace("received insecure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
            return true;
        }
        if (svc == 2386) {
            InetSocketAddress source = new InetSocketAddress(src, port);
            this.udp.sessionAuth(h, data, offset, source);
            return true;
        } else if (svc == 2384) {
            Object[] fields = this.udp.unwrap(h, data, offset);
            byte[] packet = (byte[])fields[4];
            KNXnetIPHeader containedHeader = new KNXnetIPHeader(packet, 0);
            if (containedHeader.getServiceType() != 2388) return super.handleServiceType(containedHeader, packet, containedHeader.getStructLength(), src, port);
            this.udp.sessionStatus(packet, containedHeader);
            return true;
        } else {
            this.logger.warn("received unsupported secure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
        }
        return true;
    }
}

