/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.CRD;
import tuwien.auto.calimero.knxnetip.util.HPAI;

public class ConnectResponse
extends ServiceType {
    private static final int NoMoreUniqueConnections = 37;
    private static final int AuthError = 40;
    private static final int NoTunnelingAddress = 45;
    private static final int ConnectionInUse = 46;
    private static final int Error = 15;
    private final int status;
    private int channelid;
    private CRD crd;
    private HPAI endpt;

    public ConnectResponse(byte[] data, int offset) throws KNXFormatException {
        super(518);
        if (data.length - offset < 2) {
            throw new KNXFormatException("buffer too short for response");
        }
        int i = offset;
        this.channelid = data[i++] & 0xFF;
        this.status = data[i++] & 0xFF;
        if (this.status == 0) {
            this.endpt = new HPAI(data, i);
            this.crd = CRD.createResponse(data, i + this.endpt.getStructLength());
        }
    }

    public ConnectResponse(int status) {
        super(518);
        if (status < 0 || status > 255) {
            throw new KNXIllegalArgumentException("status code out of range [0..255]");
        }
        this.status = status;
    }

    public ConnectResponse(int channelID, int status, HPAI dataEndpoint, CRD responseData) {
        super(518);
        if (channelID < 0 || channelID > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..255]");
        }
        if (status < 0 || status > 255) {
            throw new KNXIllegalArgumentException("status code out of range [0..255]");
        }
        this.channelid = channelID;
        this.status = status;
        this.endpt = dataEndpoint;
        this.crd = responseData;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final CRD getCRD() {
        return this.crd;
    }

    public final HPAI getDataEndpoint() {
        return this.endpt;
    }

    public final int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        switch (this.status) {
            case 0: {
                return "the connection was established successfully";
            }
            case 34: {
                return "the requested connection type is not supported";
            }
            case 35: {
                return "one or more connection options are not supported";
            }
            case 36: {
                return "could not accept new connection (maximum reached)";
            }
            case 37: {
                return "KNXnet/IP tunneling address for connection is not unique";
            }
            case 39: {
                return "server detected error concerning KNX subsystem connection";
            }
            case 41: {
                return "the requested tunneling layer is not supported";
            }
            case 40: {
                return "not authorized to establish the requested connection";
            }
            case 45: {
                return "requested address is not a tunneling address";
            }
            case 46: {
                return "requested address is in use";
            }
            case 15: {
                return "undefined error";
            }
        }
        return "unknown status";
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.getStatusString() + ")";
    }

    @Override
    int getStructLength() {
        int len = 2;
        if (this.endpt != null && this.crd != null) {
            len += this.endpt.getStructLength() + this.crd.getStructLength();
        }
        return len;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(this.channelid);
        os.write(this.status);
        if (this.endpt != null && this.crd != null) {
            byte[] buf = this.endpt.toByteArray();
            os.write(buf, 0, buf.length);
            buf = this.crd.toByteArray();
            os.write(buf, 0, buf.length);
        }
        return os.toByteArray();
    }
}

