/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.HPAI;

public class ConnectionstateRequest
extends ServiceType {
    private final int channelid;
    private final HPAI endpt;

    public ConnectionstateRequest(byte[] data, int offset) throws KNXFormatException {
        super(519);
        if (data.length - offset < 3) {
            throw new KNXFormatException("buffer too short for request");
        }
        this.channelid = data[offset] & 0xFF;
        this.endpt = new HPAI(data, offset + 2);
    }

    public ConnectionstateRequest(int channelID, HPAI ctrlEP) {
        super(519);
        if (channelID < 0 || channelID > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..255]");
        }
        this.channelid = channelID;
        this.endpt = ctrlEP;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final HPAI getControlEndpoint() {
        return this.endpt;
    }

    @Override
    int getStructLength() {
        return 2 + this.endpt.getStructLength();
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(this.channelid);
        os.write(0);
        byte[] buf = this.endpt.toByteArray();
        os.write(buf, 0, buf.length);
        return os.toByteArray();
    }
}

