/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public class ConnectionstateResponse
extends ServiceType {
    private final int channelid;
    private final int status;

    public ConnectionstateResponse(byte[] data, int offset) throws KNXFormatException {
        super(520);
        if (data.length - offset < 2) {
            throw new KNXFormatException("buffer too short for response");
        }
        this.channelid = data[offset] & 0xFF;
        this.status = data[offset + 1] & 0xFF;
    }

    public ConnectionstateResponse(int channelID, int status) {
        super(520);
        if (channelID < 0 || channelID > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..255]");
        }
        if (status < 0 || status > 255) {
            throw new KNXIllegalArgumentException("status code out of range [0..255]");
        }
        this.channelid = channelID;
        this.status = status;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        switch (this.status) {
            case 0: {
                return "connection state is normal";
            }
            case 33: {
                return "server could not find active data connection with specified ID";
            }
            case 38: {
                return "server detected error concerning the data connection";
            }
            case 39: {
                return "server detected error concerning the KNX bus/subsystem connection";
            }
        }
        return "unknown status";
    }

    @Override
    int getStructLength() {
        return 2;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(this.channelid);
        os.write(this.status);
        return os.toByteArray();
    }
}

