/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.AdditionalDeviceDib;
import tuwien.auto.calimero.knxnetip.util.DIB;
import tuwien.auto.calimero.knxnetip.util.DeviceDIB;
import tuwien.auto.calimero.knxnetip.util.IPConfigDIB;
import tuwien.auto.calimero.knxnetip.util.IPCurrentConfigDIB;
import tuwien.auto.calimero.knxnetip.util.KnxAddressesDIB;
import tuwien.auto.calimero.knxnetip.util.ManufacturerDIB;
import tuwien.auto.calimero.knxnetip.util.ServiceFamiliesDIB;
import tuwien.auto.calimero.knxnetip.util.TunnelingDib;

public class DescriptionResponse
extends ServiceType {
    private final Map<Integer, DIB> dibs = new HashMap<Integer, DIB>();

    public DescriptionResponse(byte[] data, int offset, int length) throws KNXFormatException {
        super(516);
        int i = offset;
        while (i + 1 < offset + length) {
            int size = data[i] & 0xFF;
            if (size == 0) break;
            int type = data[i + 1] & 0xFF;
            if (this.dibs.containsKey(type)) {
                throw new KNXFormatException("response contains duplicate DIB type", type);
            }
            DIB dib = DescriptionResponse.parseDib(type, data, i, size);
            if (dib == null) {
                logger.warn("skip unknown DIB in response of type {} and size {}", (Object)type, (Object)size);
            } else {
                this.dibs.put(type, dib);
            }
            i += size;
        }
    }

    private static DIB parseDib(int type, byte[] data, int offset, int size) throws KNXFormatException {
        switch (type) {
            case 1: {
                return new DeviceDIB(data, offset);
            }
            case 2: {
                return new ServiceFamiliesDIB(data, offset);
            }
            case 3: {
                return new IPConfigDIB(data, offset);
            }
            case 4: {
                return new IPCurrentConfigDIB(data, offset);
            }
            case 5: {
                return new KnxAddressesDIB(data, offset);
            }
            case 254: {
                return new ManufacturerDIB(data, offset);
            }
            case 6: {
                return new ServiceFamiliesDIB(data, offset);
            }
            case 7: {
                return new TunnelingDib(data, offset, size);
            }
            case 8: {
                return new AdditionalDeviceDib(data, offset, size);
            }
        }
        return null;
    }

    public DescriptionResponse(DeviceDIB device, ServiceFamiliesDIB svcFamilies, DIB ... additionalDibs) {
        super(516);
        this.dibs.put(device.getDescTypeCode(), device);
        this.dibs.put(svcFamilies.getDescTypeCode(), svcFamilies);
        DIB[] dIBArray = additionalDibs;
        int n = additionalDibs.length;
        int n2 = 0;
        while (n2 < n) {
            DIB dib = dIBArray[n2];
            int type = dib.getDescTypeCode();
            if (this.dibs.containsKey(type)) {
                throw new KNXIllegalArgumentException("response contains duplicate DIB type " + type);
            }
            this.dibs.put(type, dib);
            ++n2;
        }
    }

    DescriptionResponse(List<DIB> dibs) {
        super(516);
        for (DIB dib : dibs) {
            int type = dib.getDescTypeCode();
            if (this.dibs.containsKey(type)) {
                throw new KNXIllegalArgumentException("response contains duplicate DIB type " + type);
            }
            this.dibs.put(type, dib);
        }
    }

    public final List<DIB> getDescription() {
        return Arrays.asList(this.dibs.values().toArray(new DIB[this.dibs.size()]));
    }

    public final DeviceDIB getDevice() {
        return (DeviceDIB)this.dibs.get(1);
    }

    public final ServiceFamiliesDIB getServiceFamilies() {
        return (ServiceFamiliesDIB)this.dibs.get(2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DescriptionResponse)) {
            return false;
        }
        DescriptionResponse other = (DescriptionResponse)obj;
        return this.dibs.equals(other.dibs);
    }

    public int hashCode() {
        return 17 * this.dibs.hashCode();
    }

    @Override
    public String toString() {
        return this.getDescription().stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    int getStructLength() {
        int len = 0;
        Iterator<DIB> i = this.getDescription().iterator();
        while (i.hasNext()) {
            len += i.next().getStructLength();
        }
        return len;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        Iterator<DIB> i = this.getDescription().iterator();
        while (i.hasNext()) {
            byte[] bytes = i.next().toByteArray();
            os.write(bytes, 0, bytes.length);
        }
        return os.toByteArray();
    }
}

