/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.HPAI;

public class DisconnectRequest
extends ServiceType {
    private final int channelid;
    private final HPAI endpt;

    public DisconnectRequest(byte[] data, int offset) throws KNXFormatException {
        super(521);
        if (data.length - offset < 3) {
            throw new KNXFormatException("buffer too short for disconnect request");
        }
        int i = offset;
        this.channelid = data[i++] & 0xFF;
        this.endpt = new HPAI(data, ++i);
    }

    public DisconnectRequest(int channelID, HPAI ctrlEndpoint) {
        super(521);
        if (channelID < 0 || channelID > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..255]");
        }
        this.channelid = channelID;
        this.endpt = ctrlEndpoint;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final HPAI getEndpoint() {
        return this.endpt;
    }

    @Override
    int getStructLength() {
        return this.endpt.getStructLength() + 2;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(this.channelid);
        os.write(0);
        byte[] buf = this.endpt.toByteArray();
        os.write(buf, 0, buf.length);
        return os.toByteArray();
    }
}

