/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public class KNXnetIPHeader {
    public static final int CONNECT_REQ = 517;
    public static final int CONNECT_RES = 518;
    public static final int CONNECTIONSTATE_REQ = 519;
    public static final int CONNECTIONSTATE_RES = 520;
    public static final int DISCONNECT_REQ = 521;
    public static final int DISCONNECT_RES = 522;
    public static final int DESCRIPTION_REQ = 515;
    public static final int DESCRIPTION_RES = 516;
    public static final int SEARCH_REQ = 513;
    public static final int SEARCH_RES = 514;
    public static final int DEVICE_CONFIGURATION_REQ = 784;
    public static final int DEVICE_CONFIGURATION_ACK = 785;
    public static final int TUNNELING_REQ = 1056;
    public static final int TUNNELING_ACK = 1057;
    public static final int ROUTING_IND = 1328;
    public static final int ROUTING_LOST_MSG = 1329;
    public static final int ROUTING_BUSY = 1330;
    public static final int RoutingSystemBroadcast = 1331;
    public static final int KNXNETIP_VERSION_10 = 16;
    public static final int SearchRequest = 523;
    public static final int SearchResponse = 524;
    public static final int SecureWrapper = 2384;
    private static final int SecureSessionRequest = 2385;
    private static final int SecureSessionResponse = 2386;
    private static final int SecureSessionAuth = 2387;
    private static final int SecureSessionStatus = 2388;
    private static final int SecureGroupSync = 2389;
    public static final int TunnelingFeatureGet = 1058;
    public static final int TunnelingFeatureResponse = 1059;
    public static final int TunnelingFeatureSet = 1060;
    public static final int TunnelingFeatureInfo = 1061;
    public static final int ObjectServerRequest = 61568;
    public static final int ObjectServerAck = 61569;
    private static final int HEADER_SIZE_10 = 6;
    private final int headersize;
    private final int service;
    private final int totalsize;
    private final int version;

    public static KNXnetIPHeader from(byte[] frame, int offset) throws KNXFormatException {
        ByteBuffer buf = ByteBuffer.wrap(frame, offset, frame.length);
        if (buf.remaining() < 6) {
            throw new KNXFormatException("buffer too short for KNXnet/IP header");
        }
        int headersize = buf.get() & 0xFF;
        if (headersize != 6) {
            throw new KNXFormatException("unsupported header size, expected 6", headersize);
        }
        int version = buf.get() & 0xFF;
        int service = buf.getShort() & 0xFFFF;
        int totalsize = buf.getShort() & 0xFFFF;
        return new KNXnetIPHeader(service, version, totalsize - 6);
    }

    public KNXnetIPHeader(byte[] frame, int offset) throws KNXFormatException {
        if (frame.length - offset < 6) {
            throw new KNXFormatException("buffer too short for KNXnet/IP header");
        }
        int i = offset;
        this.headersize = frame[i++] & 0xFF;
        this.version = frame[i++] & 0xFF;
        int high = frame[i++] & 0xFF;
        int low = frame[i++] & 0xFF;
        this.service = high << 8 | low;
        high = frame[i++] & 0xFF;
        low = frame[i++] & 0xFF;
        this.totalsize = high << 8 | low;
        if (this.headersize != 6) {
            throw new KNXFormatException("unsupported header size, expected 6", this.headersize);
        }
        int expectedVersion = KNXnetIPHeader.version(this.service);
        if (this.version != expectedVersion) {
            throw new KNXFormatException(String.format("unsupported KNXnet/IP protocol version, expected 0x%1h", expectedVersion), this.version);
        }
        if (this.totalsize < 6) {
            throw new KNXFormatException(String.format("KNXnet/IP header contains invalid total length < %d", 6), this.totalsize);
        }
    }

    public KNXnetIPHeader(int serviceType, int serviceLength) {
        this(serviceType, KNXnetIPHeader.version(serviceType), serviceLength);
    }

    public KNXnetIPHeader(int serviceType, int version, int serviceLength) {
        if (serviceType < 0 || serviceType > 65535) {
            throw new KNXIllegalArgumentException("service type out of range [0..0xFFFF]");
        }
        if (version < 16 || version > 255) {
            throw new KNXIllegalArgumentException("version out of range [0x10..0xFF]");
        }
        if (serviceLength < 0) {
            throw new KNXIllegalArgumentException("negative length of message body");
        }
        this.headersize = 6;
        this.service = serviceType;
        this.version = version;
        this.totalsize = this.headersize + serviceLength;
    }

    public final boolean isSecure() {
        return this.getVersion() == 16 && (this.getServiceType() & 0x950) == 2384;
    }

    public final int getServiceType() {
        return this.service;
    }

    public int getVersion() {
        return this.version;
    }

    public int getStructLength() {
        return 6;
    }

    public final int getTotalLength() {
        return this.totalsize;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.headersize);
        os.write(this.version);
        os.write(this.service >> 8);
        os.write(this.service);
        os.write(this.totalsize >> 8);
        os.write(this.totalsize);
        return os.toByteArray();
    }

    public String toString() {
        return "KNXnet/IP " + KNXnetIPHeader.getSvcName(this.service) + " (0x" + Integer.toHexString(this.service) + " v" + this.version / 16 + "." + this.version % 16 + ") length " + this.totalsize;
    }

    static String getSvcName(int svcType) {
        switch (svcType) {
            case 517: {
                return "connect.req";
            }
            case 518: {
                return "connect.res";
            }
            case 519: {
                return "connectionstate.req";
            }
            case 520: {
                return "connectionstate.res";
            }
            case 521: {
                return "disconnect.req";
            }
            case 522: {
                return "disconnect.res";
            }
            case 515: {
                return "description.req";
            }
            case 516: {
                return "description.res";
            }
            case 513: {
                return "search.req";
            }
            case 514: {
                return "search.res";
            }
            case 784: {
                return "device-configuration.req";
            }
            case 785: {
                return "device-configuration.ack";
            }
            case 1056: {
                return "tunneling.req";
            }
            case 1057: {
                return "tunneling.ack";
            }
            case 1328: {
                return "routing.ind";
            }
            case 1329: {
                return "routing-lost.msg";
            }
            case 1330: {
                return "routing-busy.ind";
            }
            case 1331: {
                return "routing-system-broadcast";
            }
            case 523: {
                return "search.req";
            }
            case 524: {
                return "search.res";
            }
            case 2384: {
                return "secure-msg";
            }
            case 2385: {
                return "session.req";
            }
            case 2386: {
                return "session.res";
            }
            case 2387: {
                return "session-auth";
            }
            case 2388: {
                return "session-status";
            }
            case 2389: {
                return "group-sync";
            }
            case 1058: {
                return "tunneling-feat.get";
            }
            case 1059: {
                return "tunneling-feat.res";
            }
            case 1060: {
                return "tunneling-feat.set";
            }
            case 1061: {
                return "tunneling-feat.info";
            }
        }
        return "unknown service";
    }

    private static int version(int serviceType) {
        return serviceType == 61568 || serviceType == 61569 ? 32 : 16;
    }
}

