/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.HPAI;

public final class PacketHelper {
    private static final int SecureSessionRequest = 2385;
    private static final int keyLength = 32;

    private PacketHelper() {
    }

    public static byte[] toPacket(ServiceType type) {
        KNXnetIPHeader h = new KNXnetIPHeader(type.svcType, type.getStructLength());
        ByteArrayOutputStream os = new ByteArrayOutputStream(h.getTotalLength());
        os.write(h.toByteArray(), 0, h.getStructLength());
        return type.toByteArray(os);
    }

    public static byte[] toPacket(int version, ServiceType type) {
        KNXnetIPHeader h = new KNXnetIPHeader(type.svcType, version, type.getStructLength());
        ByteArrayOutputStream os = new ByteArrayOutputStream(h.getTotalLength());
        os.write(h.toByteArray(), 0, h.getStructLength());
        return type.toByteArray(os);
    }

    public static byte[] newChannelRequest(HPAI hpai, byte[] ecdhPublicKey) {
        if (ecdhPublicKey.length != 32) {
            throw new KNXIllegalArgumentException("Diffie-Hellman key required to be 32 bytes");
        }
        int length = hpai.getStructLength() + ecdhPublicKey.length;
        KNXnetIPHeader header = new KNXnetIPHeader(2385, length);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.put(hpai.toByteArray());
        buffer.put(ecdhPublicKey);
        return buffer.array();
    }
}

