/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.time.Duration;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public class RoutingBusy
extends ServiceType {
    private static final int typeSize = 6;
    private final int state;
    private final Duration waitTime;
    private final int ctrl;

    public RoutingBusy(byte[] data, int offset) throws KNXFormatException {
        super(1330);
        if (data.length - offset < 6) {
            throw new KNXFormatException("buffer too short for routing busy indication");
        }
        int size = data[offset] & 0xFF;
        if (size != 6) {
            throw new KNXFormatException("wrong size for routing busy indication", size);
        }
        this.state = data[offset + 1] & 0xFF;
        this.waitTime = Duration.ofMillis((data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF);
        this.ctrl = (data[offset + 4] & 0xFF) << 8 | data[offset + 5] & 0xFF;
    }

    public RoutingBusy(int deviceState, Duration waitTime, int control) {
        super(1330);
        if (waitTime.toMillis() < 20L || waitTime.toMillis() > 100L) {
            throw new KNXIllegalArgumentException("wait time out of range [20..100] ms");
        }
        if (deviceState < 0 || deviceState > 255) {
            throw new KNXIllegalArgumentException("device state field out of range [0..0xFF]");
        }
        if (deviceState > 3) {
            ServiceType.logger.info("Bits 2..7 not supported in device state");
        }
        this.state = deviceState;
        this.waitTime = waitTime;
        this.ctrl = control;
    }

    public final int getDeviceState() {
        return this.state;
    }

    public final boolean isKnxFault() {
        return (this.state & 1) != 0;
    }

    public final Duration waitTime() {
        return this.waitTime;
    }

    public final int getControl() {
        return this.ctrl;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " 0x" + Integer.toHexString(this.ctrl) + (this.isKnxFault() ? " KNX network fault" : "") + ", wait " + this.waitTime.toMillis() + " ms";
    }

    @Override
    int getStructLength() {
        return 6;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(6);
        os.write(this.state);
        os.write((int)(this.waitTime.toMillis() >> 8));
        os.write((int)this.waitTime.toMillis());
        os.write(this.ctrl >> 8);
        os.write(this.ctrl);
        return os.toByteArray();
    }
}

