/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.util.Optional;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public class RoutingSystemBroadcast
extends ServiceType {
    private final CEMI cemi;
    private static final int SystemNetworkParamRead = 456;
    private static final int SystemNetworkParamResponse = 457;
    private static final int DoASerialNumberWrite = 1006;
    private static final int SecureService = 1009;
    private static final int SecureDataPdu = 0;
    private static final int SecureSyncRequest = 2;
    private static final int SecureSyncResponse = 3;

    public RoutingSystemBroadcast(CEMI frame) {
        super(1331);
        if (!RoutingSystemBroadcast.validSystemBroadcast(frame)) {
            throw new KNXIllegalArgumentException("invalid frame for IP system broadcast");
        }
        this.cemi = CEMIFactory.copy(frame);
    }

    public RoutingSystemBroadcast(byte[] data, int offset, int length) throws KNXFormatException {
        super(1331);
        this.cemi = CEMIFactory.create(data, offset, length);
        if (!RoutingSystemBroadcast.validSystemBroadcast(this.cemi)) {
            throw new KNXFormatException("cEMI frame is not a valid system broadcast " + this.cemi);
        }
    }

    public final CEMI cemi() {
        return CEMIFactory.copy(this.cemi);
    }

    @Override
    int getStructLength() {
        return this.cemi.getStructLength();
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        byte[] buf = this.cemi.toByteArray();
        os.write(buf, 0, buf.length);
        return os.toByteArray();
    }

    public static boolean isSubnetSystemBroadcast(CEMI frame) {
        return RoutingSystemBroadcast.payload(frame).map(RoutingSystemBroadcast::subnetSystemBroadcast).orElse(false);
    }

    public static boolean isIpSystemBroadcast(CEMI frame) {
        return RoutingSystemBroadcast.payload(frame).map(RoutingSystemBroadcast::ipSystemBroadcast).orElse(false);
    }

    @Deprecated
    public static boolean isSystemBroadcast(CEMI frame) {
        return RoutingSystemBroadcast.isSubnetSystemBroadcast(frame);
    }

    public static boolean validSystemBroadcast(CEMI frame) {
        return RoutingSystemBroadcast.payload(frame).map(tpdu -> RoutingSystemBroadcast.subnetSystemBroadcast(tpdu) || RoutingSystemBroadcast.ipSystemBroadcast(tpdu)).orElse(false);
    }

    private static boolean subnetSystemBroadcast(byte[] tpdu) {
        switch (DataUnitBuilder.getAPDUService(tpdu)) {
            case 456: {
                return tpdu.length == 7 && tpdu[2] == 0 && tpdu[3] == 0 && tpdu[4] == 0 && (tpdu[5] & 0xFF) == 176 && tpdu[6] == 1;
            }
            case 1006: {
                return tpdu.length == 12;
            }
            case 1009: {
                return RoutingSystemBroadcast.secureService(tpdu, 0, 2);
            }
        }
        return false;
    }

    private static boolean ipSystemBroadcast(byte[] tpdu) {
        switch (DataUnitBuilder.getAPDUService(tpdu)) {
            case 457: {
                return tpdu.length == 13 && tpdu[2] == 0 && tpdu[3] == 0 && tpdu[4] == 0 && (tpdu[5] & 0xFF) == 176 && tpdu[6] == 1;
            }
            case 1009: {
                return RoutingSystemBroadcast.secureService(tpdu, 3, 3);
            }
        }
        return false;
    }

    private static boolean secureService(byte[] tpdu, int svc1, int svc2) {
        int scf = tpdu[2] & 0xFF;
        boolean toolAccess = (scf & 0x80) == 128;
        int algorithmId = scf >> 4 & 7;
        boolean systemBroadcast = (scf & 8) == 8;
        int service = scf & 3;
        return (service == svc1 || service == svc2) && toolAccess && systemBroadcast && algorithmId == 1;
    }

    private static Optional<byte[]> payload(CEMI frame) {
        byte[] tpdu;
        CEMILData ldata;
        KNXAddress dst;
        if (frame.getMessageCode() == 41 && frame instanceof CEMILData && (dst = (ldata = (CEMILData)frame).getDestination()) instanceof GroupAddress && dst.getRawAddress() == 0 && (tpdu = ldata.getPayload()).length >= 2) {
            return Optional.of(tpdu);
        }
        return Optional.empty();
    }
}

