/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.ErrorCodes;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;

public class ServiceAck
extends ServiceType {
    private static final int CONN_HEADER_SIZE = 4;
    private final int channelid;
    private final int seq;
    private final int status;

    public ServiceAck(int serviceType, byte[] data, int offset) throws KNXFormatException {
        super(serviceType);
        if (data.length - offset < 4) {
            throw new KNXFormatException("buffer too short for service ack");
        }
        int i = offset;
        if ((data[i++] & 0xFF) != 4) {
            throw new KNXFormatException("unsupported connection header");
        }
        this.channelid = data[i++] & 0xFF;
        this.seq = data[i++] & 0xFF;
        this.status = data[i++] & 0xFF;
    }

    public ServiceAck(int serviceType, int channelId, int seqNumber, int status) {
        super(serviceType);
        if (serviceType < 0 || serviceType > 65535) {
            throw new KNXIllegalArgumentException("ack service type out of range [0..0xffff]");
        }
        if (channelId < 0 || channelId > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..0xff]");
        }
        if (seqNumber < 0 || seqNumber > 255) {
            throw new KNXIllegalArgumentException("sequence number out of range [0..0xff]");
        }
        if (status < 0 || status > 255) {
            throw new KNXIllegalArgumentException("status code out of range [0..0xff]");
        }
        this.channelid = channelId;
        this.seq = seqNumber;
        this.status = status;
    }

    public final int getServiceType() {
        return this.svcType;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final int getSequenceNumber() {
        return this.seq;
    }

    public final int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return ErrorCodes.getErrorMessage(this.status);
    }

    @Override
    int getStructLength() {
        return 4;
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(4);
        os.write(this.channelid);
        os.write(this.seq);
        os.write(this.status);
        return os.toByteArray();
    }
}

