/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.ServiceType;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.TunnelingFeature;

public class ServiceRequest<T extends ServiceType>
extends tuwien.auto.calimero.knxnetip.servicetype.ServiceType {
    private static final int CONN_HEADER_SIZE = 4;
    private final int channelid;
    private final int seq;
    private final Supplier<T> svcSupplier;
    private volatile T svc;
    private static Function<ByteBuffer, CEMI> cemiParser = buf -> {
        try {
            return CEMIFactory.create(buf.array(), buf.position(), buf.remaining());
        }
        catch (KNXFormatException e) {
            throw new KnxRuntimeException("parsing cEMI", e);
        }
    };
    private static BiFunction<Integer, ByteBuffer, TunnelingFeature> tunnelingFeatureParser = (svc, buf) -> {
        try {
            return TunnelingFeature.from(svc, buf);
        }
        catch (KNXFormatException e) {
            throw new KnxRuntimeException("parsing tunneling feature", e);
        }
    };

    public static ServiceRequest<ServiceType> from(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        return new ServiceRequest<ServiceType>(h.getServiceType(), data, offset, h.getTotalLength() - h.getStructLength());
    }

    public static <U extends ServiceType> ServiceRequest<U> from(KNXnetIPHeader h, byte[] data, int offset, Function<ByteBuffer, U> svcParser) throws KNXFormatException {
        return ServiceRequest.from(h, ByteBuffer.wrap(data, h.getStructLength(), h.getTotalLength() - h.getStructLength()), svcParser);
    }

    private static <U extends ServiceType> ServiceRequest<U> from(KNXnetIPHeader h, ByteBuffer buf, Function<ByteBuffer, U> svcParser) throws KNXFormatException {
        return new ServiceRequest<U>(h.getServiceType(), buf, svcParser);
    }

    public ServiceRequest(int serviceType, byte[] data, int offset, int length) throws KNXFormatException {
        this(serviceType, ByteBuffer.wrap(data, offset, length), ServiceRequest.parser(serviceType));
    }

    private static <T> Function<ByteBuffer, T> parser(int serviceType) throws KNXFormatException {
        if (serviceType == 1056 || serviceType == 784) {
            return cemiParser;
        }
        if (serviceType == 1058 || serviceType == 1059 || serviceType == 1060 || serviceType == 1061) {
            Function<ByteBuffer, TunnelingFeature> parse = buf -> tunnelingFeatureParser.apply(serviceType, (ByteBuffer)buf);
            return parse;
        }
        throw new KNXFormatException("unsupported service type " + Integer.toHexString(serviceType));
    }

    private ServiceRequest(int serviceType, ByteBuffer buf, Function<ByteBuffer, T> svcParser) throws KNXFormatException {
        super(serviceType);
        if (buf.remaining() < 4) {
            throw new KNXFormatException("buffer too short for service request");
        }
        if ((buf.get() & 0xFF) != 4) {
            throw new KNXFormatException("unsupported connection header");
        }
        this.channelid = buf.get() & 0xFF;
        this.seq = buf.get() & 0xFF;
        buf.get();
        this.svcSupplier = () -> (ServiceType)svcParser.apply(buf);
    }

    public ServiceRequest(int serviceType, int channelID, int seqNumber, T service) {
        super(serviceType);
        if (serviceType < 0 || serviceType > 65535) {
            throw new KNXIllegalArgumentException("service request out of range [0..0xffff]");
        }
        if (channelID < 0 || channelID > 255) {
            throw new KNXIllegalArgumentException("channel ID out of range [0..0xff]");
        }
        if (seqNumber < 0 || seqNumber > 255) {
            throw new KNXIllegalArgumentException("sequence number out of range [0..0xff]");
        }
        this.channelid = channelID;
        this.seq = seqNumber;
        this.svc = service instanceof CEMI ? CEMIFactory.copy((CEMI)service) : service;
        this.svcSupplier = null;
    }

    public final int getServiceType() {
        return this.svcType;
    }

    public final int getChannelID() {
        return this.channelid;
    }

    public final int getSequenceNumber() {
        return this.seq;
    }

    public final <R extends T> R service() {
        if (this.svc == null) {
            this.svc = (ServiceType)this.svcSupplier.get();
        }
        return (R)this.svc;
    }

    @Deprecated
    public final CEMI getCEMI() {
        return CEMIFactory.copy((CEMI)this.svc);
    }

    @Override
    int getStructLength() {
        return 4 + this.service().length();
    }

    @Override
    byte[] toByteArray(ByteArrayOutputStream os) {
        os.write(4);
        os.write(this.channelid);
        os.write(this.seq);
        os.write(0);
        byte[] buf = this.service().toByteArray();
        os.write(buf, 0, buf.length);
        return os.toByteArray();
    }
}

