/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.log.LogService;

abstract class ServiceType
implements tuwien.auto.calimero.ServiceType {
    static final Logger logger = LogService.getLogger("KNXnet/IP service");
    final int svcType;

    ServiceType(int serviceType) {
        if (serviceType < 0 || serviceType > 65535) {
            throw new KNXIllegalArgumentException("service type out of range [0..0xffff]");
        }
        this.svcType = serviceType;
    }

    @Override
    public int length() {
        return this.getStructLength();
    }

    @Override
    public final byte[] toByteArray() {
        return this.toByteArray(new ByteArrayOutputStream(50));
    }

    public String toString() {
        return KNXnetIPHeader.getSvcName(this.svcType);
    }

    abstract byte[] toByteArray(ByteArrayOutputStream var1);

    abstract int getStructLength();
}

