/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.servicetype;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.ServiceType;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;

public final class TunnelingFeature
implements ServiceType {
    private static final int MinServiceSize = 2;
    private final int svcType;
    private final InterfaceFeature featureId;
    private final ReturnCode status;
    private final byte[] data;

    public static TunnelingFeature newGet(InterfaceFeature featureId) {
        return new TunnelingFeature(1058, featureId, ReturnCode.Success, new byte[0]);
    }

    public static TunnelingFeature newResponse(InterfaceFeature featureId, ReturnCode result, byte ... featureValue) {
        return new TunnelingFeature(1059, featureId, result, featureValue);
    }

    public static TunnelingFeature newSet(InterfaceFeature featureId, byte ... featureValue) {
        return new TunnelingFeature(1060, featureId, ReturnCode.Success, featureValue);
    }

    public static TunnelingFeature newInfo(InterfaceFeature featureId, byte ... featureValue) {
        return new TunnelingFeature(1061, featureId, ReturnCode.Success, featureValue);
    }

    public static TunnelingFeature from(int svcType, ByteBuffer buffer) throws KNXFormatException {
        return new TunnelingFeature(svcType, buffer);
    }

    private TunnelingFeature(int serviceType, InterfaceFeature featureId, ReturnCode status, byte ... data) {
        this.svcType = serviceType;
        this.featureId = featureId;
        this.status = status;
        this.data = (byte[])data.clone();
        this.validateFeatureValueLength();
    }

    private TunnelingFeature(int svcType, ByteBuffer bb) throws KNXFormatException {
        if (bb.remaining() < 2) {
            throw new KNXFormatException("buffer too short for tunneling feature service");
        }
        int id = bb.get() & 0xFF;
        if (id > InterfaceFeature.values().length) {
            throw new KNXFormatException(ReturnCode.AddressVoid.description(), id);
        }
        this.svcType = svcType;
        this.featureId = InterfaceFeature.values()[id - 1];
        this.status = ReturnCode.of(bb.get() & 0xFF);
        if (this.status.code() > 240) {
            tuwien.auto.calimero.knxnetip.servicetype.ServiceType.logger.warn("feature {} responded with '{}'", (Object)this.featureId, (Object)this.status);
        }
        this.data = new byte[bb.remaining()];
        bb.get(this.data);
        this.validateFeatureValueLength();
    }

    private void validateFeatureValueLength() {
        int length;
        if (this.svcType == 1058) {
            length = 0;
        } else {
            switch (this.featureId) {
                case SupportedEmiTypes: 
                case DeviceDescriptorType0: 
                case Manufacturer: 
                case IndividualAddress: 
                case MaxApduLength: {
                    length = 2;
                    break;
                }
                case ConnectionStatus: 
                case ActiveEmiType: 
                case EnableFeatureInfoService: {
                    length = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (this.data.length != length) {
            throw new KNXIllegalArgumentException(String.format("%s %s value %s with invalid length %d, expected %d", new Object[]{KNXnetIPHeader.getSvcName(this.svcType), this.featureId, DataUnitBuilder.toHex(this.data, ""), this.data.length, length}));
        }
    }

    public int type() {
        return this.svcType;
    }

    public InterfaceFeature featureId() {
        return this.featureId;
    }

    public Optional<byte[]> featureValue() {
        return this.data.length > 0 ? Optional.of(this.data) : Optional.empty();
    }

    public ReturnCode status() {
        return this.status;
    }

    public String toString() {
        ReturnCode s = this.status == ReturnCode.Success ? DataUnitBuilder.toHex(this.featureValue().orElse(new byte[0]), "") : this.status;
        return String.format("%s %s %s", new Object[]{KNXnetIPHeader.getSvcName(this.svcType), this.featureId, s});
    }

    @Override
    public int length() {
        return 2 + this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.featureId.id());
        os.write(this.status.code());
        os.write(this.data, 0, this.data.length);
        return os.toByteArray();
    }

    public static enum InterfaceFeature {
        SupportedEmiTypes,
        DeviceDescriptorType0,
        ConnectionStatus,
        Manufacturer,
        ActiveEmiType,
        IndividualAddress,
        MaxApduLength,
        EnableFeatureInfoService;


        int id() {
            return this.ordinal() + 1;
        }

        public String toString() {
            return this.friendly();
        }

        private String friendly() {
            return this.name().replaceAll("(\\p{Lower})\\B([A-Z0])", "$1 $2").toLowerCase();
        }
    }
}

