/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.CRD;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.TunnelCRD;
import tuwien.auto.calimero.knxnetip.util.TunnelCRI;
import tuwien.auto.calimero.log.LogService;

class CRBase {
    static final Logger logger = LogService.getLogger("KNXnet/IP service");
    byte[] opt;
    private final int connType;
    private final int length;

    CRBase(byte[] data, int offset) throws KNXFormatException {
        int i = offset;
        this.length = data[i++] & 0xFF;
        this.connType = data[i++] & 0xFF;
        if (this.length > data.length - offset) {
            throw new KNXFormatException("structure length bigger than buffer", this.length);
        }
        this.opt = new byte[this.length - 2];
        int k = 0;
        while (k < this.length - 2) {
            this.opt[k] = data[i];
            ++i;
            ++k;
        }
    }

    CRBase(int connectionType, byte[] optionalData) {
        if (connectionType < 0 || connectionType > 255) {
            throw new KNXIllegalArgumentException("connection type out of range [0..255]");
        }
        this.length = 2 + optionalData.length;
        if (this.length > 255) {
            throw new KNXIllegalArgumentException("optional data exceeds maximum length");
        }
        this.connType = connectionType;
        this.opt = optionalData;
    }

    static CRBase create(boolean request, byte[] data, int offset) throws KNXFormatException {
        if (data.length - offset < 2) {
            throw new KNXFormatException("buffer too short for " + (request ? "CRI" : "CRD"));
        }
        int type = data[offset + 1] & 0xFF;
        if (type == 4) {
            return request ? new TunnelCRI(data, offset) : new TunnelCRD(data, offset);
        }
        if (type != 3 && type != 240) {
            logger.warn("unknown connection type 0x" + Integer.toHexString(type) + ", create default CRI/CRD");
        }
        return request ? new CRI(data, offset) : new CRD(data, offset);
    }

    static CRBase create(boolean request, int type, byte[] data) {
        byte[] opt = data;
        if (type == 4) {
            return request ? new TunnelCRI(opt) : new TunnelCRD(opt);
        }
        if (type != 3 && type != 240) {
            logger.warn("unknown connection type 0x" + Integer.toHexString(type) + ", create default CRI/CRD");
        }
        return request ? new CRI(type, (byte[])opt.clone()) : new CRD(type, (byte[])opt.clone());
    }

    public final int getConnectionType() {
        return this.connType;
    }

    public final byte[] getOptionalData() {
        return (byte[])this.opt.clone();
    }

    public final int getStructLength() {
        return this.length;
    }

    public String toString() {
        return "connection type " + this.connType + " length " + this.length + " data " + (this.opt.length == 0 ? "-" : DataUnitBuilder.toHex(this.opt, " "));
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.length);
        os.write(this.connType);
        os.write(this.opt, 0, this.opt.length);
        return os.toByteArray();
    }
}

