/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.io.ByteArrayInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public final class IPCurrentConfigDIB
extends DIB {
    private static final int DIB_SIZE = 20;
    private final byte[] ip;
    private final byte[] subnet;
    private final byte[] gw;
    private final byte[] dhcp;
    private final int assignment;

    public IPCurrentConfigDIB(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.type != 4) {
            throw new KNXFormatException("no IP current config DIB, wrong type ID " + this.type);
        }
        if (this.size < 20) {
            throw new KNXFormatException("IP current config DIB too short, < 20", this.size);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset + 2, data.length - offset - 2);
        this.ip = new byte[4];
        this.subnet = new byte[4];
        this.gw = new byte[4];
        this.dhcp = new byte[4];
        is.read(this.ip, 0, this.ip.length);
        is.read(this.subnet, 0, this.subnet.length);
        is.read(this.gw, 0, this.gw.length);
        is.read(this.dhcp, 0, this.dhcp.length);
        this.assignment = is.read();
        int reserved = is.read();
        if (reserved != 0) {
            throw new KNXFormatException("reserved field shall be set 0", reserved);
        }
    }

    public IPCurrentConfigDIB(Inet4Address ip, Inet4Address subnetMask, Inet4Address gateway, Inet4Address dhcp, int ipAssignmentMethod) {
        super(20, 4);
        this.ip = ip != null ? ip.getAddress() : new byte[4];
        this.subnet = subnetMask != null ? subnetMask.getAddress() : new byte[4];
        this.gw = gateway != null ? gateway.getAddress() : new byte[4];
        byte[] byArray = this.dhcp = dhcp != null ? dhcp.getAddress() : new byte[4];
        if (ipAssignmentMethod < 0 || ipAssignmentMethod > 21 || Integer.bitCount(ipAssignmentMethod) != 1) {
            throw new KNXIllegalArgumentException("unsupported IP assignment method " + ipAssignmentMethod + " out of {1, 2, 4, 8}");
        }
        this.assignment = ipAssignmentMethod;
    }

    public Inet4Address getIPAddress() {
        return IPCurrentConfigDIB.asInet4Address(this.ip);
    }

    public Inet4Address getSubnetMask() {
        return IPCurrentConfigDIB.asInet4Address(this.subnet);
    }

    public Inet4Address getDefaultGateway() {
        return IPCurrentConfigDIB.asInet4Address(this.gw);
    }

    public Inet4Address getDhcpServer() {
        return IPCurrentConfigDIB.asInet4Address(this.dhcp);
    }

    public int getIPAssignmentMethod() {
        return this.assignment;
    }

    public String toString() {
        try {
            return "current IP " + InetAddress.getByAddress(this.ip) + ", subnet mask " + InetAddress.getByAddress(this.subnet) + ", default gateway " + InetAddress.getByAddress(this.gw) + ", DHCP server " + InetAddress.getByAddress(this.dhcp) + ", IP assignment method " + this.assignment;
        }
        catch (UnknownHostException unknownHostException) {
            return "IP current config DIB";
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] buf = super.toByteArray();
        int i = 2;
        int k = 0;
        while (k < 4) {
            buf[i++] = this.ip[k];
            ++k;
        }
        k = 0;
        while (k < 4) {
            buf[i++] = this.subnet[k];
            ++k;
        }
        k = 0;
        while (k < 4) {
            buf[i++] = this.gw[k];
            ++k;
        }
        k = 0;
        while (k < 4) {
            buf[i++] = this.dhcp[k];
            ++k;
        }
        buf[i++] = (byte)this.assignment;
        buf[i++] = 0;
        return buf;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.ip);
        result = 31 * result + Arrays.hashCode(this.subnet);
        result = 31 * result + Arrays.hashCode(this.gw);
        result = 31 * result + Arrays.hashCode(this.dhcp);
        result = 31 * result + Objects.hash(this.assignment);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPCurrentConfigDIB)) {
            return false;
        }
        IPCurrentConfigDIB other = (IPCurrentConfigDIB)obj;
        return Arrays.equals(this.ip, other.ip) && Arrays.equals(this.subnet, other.subnet) && Arrays.equals(this.gw, other.gw) && Arrays.equals(this.dhcp, other.dhcp) && this.assignment == other.assignment;
    }

    private static Inet4Address asInet4Address(byte[] addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new KNXIllegalArgumentException("illegal length of IPv4 address", e);
        }
    }
}

