/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public final class KnxAddressesDIB
extends DIB {
    private static final int DIB_MIN_SIZE = 4;
    private final List<IndividualAddress> addresses = new ArrayList<IndividualAddress>();

    public KnxAddressesDIB(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.type != 5) {
            throw new KNXFormatException("no KNX addresses DIB, wrong type ID", this.type);
        }
        if (this.size < 4) {
            throw new KNXFormatException("KNX addresses DIB too short, < 4", this.size);
        }
        if (this.size % 2 != 0) {
            throw new KNXFormatException("KNX address DIB requires even size");
        }
        int i = offset + 2;
        while (i < offset + this.size) {
            int a = (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
            this.addresses.add(new IndividualAddress(a));
            i += 2;
        }
    }

    public KnxAddressesDIB(Collection<? extends IndividualAddress> knxAddresses) {
        super(2 + 2 * knxAddresses.size(), 5);
        if (knxAddresses.isEmpty()) {
            throw new KNXIllegalArgumentException("at least one KNX address is required");
        }
        this.addresses.addAll(knxAddresses);
    }

    public List<IndividualAddress> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public String toString() {
        return this.addresses.stream().map(IndividualAddress::toString).collect(Collectors.joining(", "));
    }

    @Override
    public byte[] toByteArray() {
        byte[] buf = super.toByteArray();
        int i = 2;
        for (IndividualAddress ia : this.addresses) {
            byte[] raw = ia.toByteArray();
            buf[i++] = raw[0];
            buf[i++] = raw[1];
        }
        return buf;
    }

    public int hashCode() {
        return this.addresses.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KnxAddressesDIB)) {
            return false;
        }
        KnxAddressesDIB other = (KnxAddressesDIB)obj;
        return this.addresses.equals(other.addresses);
    }
}

