/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.CRD;

public class TunnelCRD
extends CRD {
    public TunnelCRD(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.getConnectionType() != 4) {
            throw new KNXFormatException("not a tunneling CRD", this.getConnectionType());
        }
        if (this.getStructLength() != 4) {
            throw new KNXFormatException("wrong length for tunneling CRD");
        }
    }

    public TunnelCRD(IndividualAddress addr) {
        super(4, addr.toByteArray());
    }

    TunnelCRD(byte[] optionalData) {
        super(4, (byte[])optionalData.clone());
        if (this.getStructLength() != 4) {
            throw new KNXIllegalArgumentException("wrong length for tunneling CRD");
        }
    }

    public final IndividualAddress getAssignedAddress() {
        return new IndividualAddress(this.opt);
    }

    @Override
    public String toString() {
        return "tunneling CRD, assigned address " + this.getAssignedAddress();
    }
}

