/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.util.Optional;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.util.CRI;

public class TunnelCRI
extends CRI {
    public TunnelCRI(byte[] data, int offset) throws KNXFormatException {
        super(data, offset);
        if (this.getConnectionType() != 4) {
            throw new KNXFormatException("not a tunneling CRI", this.getConnectionType());
        }
        if (!this.validLength()) {
            throw new KNXFormatException("wrong length for tunneling CRI");
        }
    }

    public TunnelCRI(KNXnetIPTunnel.TunnelingLayer knxLayer) {
        byte[] byArray = new byte[2];
        byArray[0] = (byte)knxLayer.getCode();
        super(4, byArray);
    }

    public TunnelCRI(KNXnetIPTunnel.TunnelingLayer knxLayer, IndividualAddress tunnelingAddress) {
        byte[] byArray = new byte[4];
        byArray[0] = (byte)knxLayer.getCode();
        byArray[2] = (byte)(tunnelingAddress.getRawAddress() >> 8);
        byArray[3] = (byte)tunnelingAddress.getRawAddress();
        super(4, byArray);
    }

    TunnelCRI(byte[] optionalData) {
        super(4, (byte[])optionalData.clone());
        if (!this.validLength()) {
            throw new KNXIllegalArgumentException("wrong length for tunneling CRI");
        }
    }

    public final KNXnetIPTunnel.TunnelingLayer tunnelingLayer() {
        return KNXnetIPTunnel.TunnelingLayer.from(this.opt[0] & 0xFF);
    }

    public final Optional<IndividualAddress> tunnelingAddress() {
        if (this.getStructLength() == 6) {
            return Optional.of(new IndividualAddress(new byte[]{this.opt[2], this.opt[3]}));
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "tunneling CRI, KNX " + (Object)((Object)this.tunnelingLayer());
    }

    private boolean validLength() {
        return this.getStructLength() == 4 || this.getStructLength() == 6;
    }
}

