/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip.util;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.knxnetip.util.DIB;

public class TunnelingDib
extends DIB {
    private final int maxApduLength;
    private final Map<IndividualAddress, EnumSet<SlotStatus>> slots;

    public TunnelingDib(Map<IndividualAddress, EnumSet<SlotStatus>> tunnelingSlots) {
        this(254, tunnelingSlots);
    }

    public TunnelingDib(int maxApduLength, Map<IndividualAddress, EnumSet<SlotStatus>> tunnelingSlots) {
        super(4 + 4 * tunnelingSlots.size(), 7);
        if (tunnelingSlots.isEmpty()) {
            throw new KNXIllegalArgumentException("at least one address must be given");
        }
        if (4 + 4 * tunnelingSlots.size() > 254) {
            throw new KNXIllegalArgumentException(String.valueOf(tunnelingSlots.size()) + " slots exceed DIB size limit");
        }
        this.maxApduLength = maxApduLength;
        this.slots = TunnelingDib.deepCopy(tunnelingSlots);
    }

    public TunnelingDib(byte[] data, int offset, int length) throws KNXFormatException {
        super(data, offset);
        if (this.type != 7) {
            throw new KNXFormatException("not a tunneling DIB", this.type);
        }
        if (length < 8) {
            throw new KNXFormatException("tunneling DIB too short", length);
        }
        if (length > 254) {
            throw new KNXFormatException("tunneling DIB exceeds max size", length);
        }
        ByteBuffer buf = ByteBuffer.wrap(data, offset + 2, length - 2);
        this.maxApduLength = buf.getShort() & 0xFFFF;
        this.slots = new LinkedHashMap<IndividualAddress, EnumSet<SlotStatus>>();
        int entries = buf.remaining() / 4;
        int i = 0;
        while (i < entries) {
            IndividualAddress address = new IndividualAddress(buf.getShort() & 0xFFFF);
            buf.get();
            int status = buf.get() & 7;
            this.slots.put(address, TunnelingDib.toStatusSet(status));
            ++i;
        }
    }

    public int maxApduLength() {
        return this.maxApduLength;
    }

    public final Map<IndividualAddress, EnumSet<SlotStatus>> slots() {
        return TunnelingDib.deepCopy(this.slots);
    }

    public String toString() {
        Collector<CharSequence, ?, String> joiner = Collectors.joining(", ", "maximum APDU length: " + this.maxApduLength + ", tunneling slots: ", "");
        return this.slots.entrySet().stream().map(slot -> slot.getKey() + " " + slot.getValue()).collect(joiner);
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.wrap(super.toByteArray()).position(2);
        buf.putShort((short)this.maxApduLength);
        for (Map.Entry<IndividualAddress, EnumSet<SlotStatus>> slot : this.slots.entrySet()) {
            buf.put(slot.getKey().toByteArray());
            buf.put((byte)-1);
            int status = slot.getValue().stream().mapToInt(SlotStatus::value).sum();
            buf.put((byte)(status | 0xF8));
        }
        return buf.array();
    }

    public int hashCode() {
        return Objects.hash(this.maxApduLength, this.slots);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TunnelingDib)) {
            return false;
        }
        TunnelingDib other = (TunnelingDib)obj;
        return this.maxApduLength == other.maxApduLength && this.slots.equals(other.slots);
    }

    private static EnumSet<SlotStatus> toStatusSet(int status) {
        EnumSet<SlotStatus> set = EnumSet.noneOf(SlotStatus.class);
        SlotStatus[] slotStatusArray = SlotStatus.values();
        int n = slotStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            SlotStatus v = slotStatusArray[n2];
            if ((status >> v.ordinal() & 1) == 1) {
                set.add(v);
            }
            ++n2;
        }
        return set;
    }

    private static Map<IndividualAddress, EnumSet<SlotStatus>> deepCopy(Map<IndividualAddress, EnumSet<SlotStatus>> map) {
        LinkedHashMap<IndividualAddress, EnumSet<SlotStatus>> copy = new LinkedHashMap<IndividualAddress, EnumSet<SlotStatus>>(map);
        copy.replaceAll((__, set) -> set.clone());
        return copy;
    }

    public static enum SlotStatus {
        Free,
        Authorized,
        Usable;


        public int value() {
            return (int)Math.pow(2.0, this.ordinal());
        }

        public static SlotStatus of(int value) {
            switch (value) {
                case 1: {
                    return Free;
                }
                case 2: {
                    return Authorized;
                }
                case 4: {
                    return Usable;
                }
            }
            throw new KNXIllegalArgumentException(String.valueOf(value) + " is not a valid status value");
        }
    }
}

