/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIBusMon;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.link.Connector;
import tuwien.auto.calimero.link.EventNotifier;
import tuwien.auto.calimero.link.KNXNetworkMonitor;
import tuwien.auto.calimero.link.LinkListener;
import tuwien.auto.calimero.link.MonitorFrameEvent;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RawFrame;
import tuwien.auto.calimero.link.medium.RawFrameFactory;
import tuwien.auto.calimero.log.LogService;

public abstract class AbstractMonitor<T extends AutoCloseable>
implements KNXNetworkMonitor {
    protected final MonitorNotifier notifier;
    protected final Logger logger;
    final T conn;
    volatile boolean wrappedByConnector;
    private volatile boolean closed;
    private KNXMediumSettings medium;
    private final String name;

    protected AbstractMonitor(T conn, String name, KNXMediumSettings settings) {
        this.conn = conn;
        this.name = name;
        this.logger = LogService.getLogger("calimero.link." + this.getName());
        if (settings instanceof PLSettings) {
            this.logger.info("power-line medium, assuming BCU has extended busmonitor enabled");
        }
        this.setKNXMedium(settings);
        this.notifier = new MonitorNotifier(this, this.logger, settings instanceof PLSettings);
        this.notifier.start();
    }

    @Override
    public final void setKNXMedium(KNXMediumSettings settings) {
        if (settings == null) {
            throw new KNXIllegalArgumentException("medium settings are mandatory");
        }
        if (this.medium != null && !settings.getClass().isAssignableFrom(this.medium.getClass()) && !this.medium.getClass().isAssignableFrom(settings.getClass())) {
            throw new KNXIllegalArgumentException("medium differs");
        }
        this.medium = settings;
    }

    @Override
    public final KNXMediumSettings getKNXMedium() {
        return this.medium;
    }

    @Override
    public void addMonitorListener(LinkListener l) {
        this.notifier.addListener(l);
    }

    @Override
    public void removeMonitorListener(LinkListener l) {
        this.notifier.removeListener(l);
    }

    @Override
    public final void setDecodeRawFrames(boolean decode) {
        this.notifier.decode = decode;
        this.logger.info(String.valueOf(decode ? "enable" : "disable") + " decoding of raw frames");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        AbstractMonitor abstractMonitor = this;
        synchronized (abstractMonitor) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.leaveBusmonitor();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.onClose();
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {}
        this.notifier.quit();
    }

    public String toString() {
        return "monitor " + this.getName() + " " + this.medium.getMediumString() + " medium" + (this.notifier.decode ? ", raw frame decoding" : "") + (this.closed ? " (closed)" : "");
    }

    protected void onClose() {
    }

    protected void leaveBusmonitor() throws InterruptedException {
    }

    private static final class MonitorNotifier
    extends EventNotifier<LinkListener> {
        volatile boolean decode;
        private boolean extBusmon;

        MonitorNotifier(AbstractMonitor<?> source, Logger logger, boolean extBusmon) {
            super(source, logger);
            this.extBusmon = extBusmon;
        }

        @Override
        public void frameReceived(FrameEvent e) {
            try {
                MonitorFrameEvent mfe;
                block9: {
                    CEMIBusMon mon;
                    CEMI frame = e.getFrame();
                    if (frame == null) {
                        mon = (CEMIBusMon)CEMIFactory.fromEmiBusmon(e.getFrameBytes());
                    } else if (frame instanceof CEMIBusMon) {
                        mon = (CEMIBusMon)frame;
                    } else {
                        this.logger.warn("received unsupported frame type with msg code 0x" + Integer.toHexString(frame.getMessageCode()));
                        return;
                    }
                    this.logger.trace("{}", (Object)mon);
                    AbstractMonitor netmon = (AbstractMonitor)this.source;
                    mfe = new MonitorFrameEvent(netmon, (CEMI)mon);
                    if (this.decode) {
                        try {
                            RawFrame rf = RawFrameFactory.create(netmon.medium.getMedium(), mon.getPayload(), 0, this.extBusmon);
                            mfe = new MonitorFrameEvent((KNXNetworkMonitor)netmon, (CEMI)mon, rf);
                        }
                        catch (KNXFormatException ex) {
                            this.logger.warn("decoding raw frame", (Throwable)ex);
                            mfe = new MonitorFrameEvent((KNXNetworkMonitor)netmon, (CEMI)mon, ex);
                            if (!this.extBusmon) break block9;
                            this.extBusmon = false;
                            this.logger.warn("disable extended busmonitor mode, maybe this helps");
                        }
                    }
                }
                MonitorFrameEvent event = mfe;
                this.addEvent(l -> l.indication(event));
            }
            catch (RuntimeException | KNXFormatException ex) {
                this.logger.warn("unspecified frame event - ignored", (Throwable)ex);
            }
        }

        @Override
        public void connectionClosed(CloseEvent e) {
            AbstractMonitor monitor = (AbstractMonitor)this.source;
            monitor.closed = true;
            this.logger.info("monitor closed");
            if (monitor.wrappedByConnector) {
                this.getListeners().listeners().stream().filter(Connector.Link.class::isInstance).forEach(l -> l.linkClosed(e));
                return;
            }
            super.connectionClosed(e);
        }
    }
}

