/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Function;
import org.slf4j.Logger;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.serial.KNXPortClosedException;

final class BcuSwitcher<T> {
    static final int AddrSystemState = 96;
    static final int AddrBaseConfig = 257;
    static final int AddrDomainAddress = 258;
    static final int AddrExpectedPeiType = 265;
    static final int AddrStartAddressTable = 278;
    static final int AddrIndividualAddress = 279;
    private static final int getValue_req = 76;
    private static final int getValue_con = 75;
    private static final int setValue_req = 70;
    private static final int frameOffsetData = 4;
    private static final int responseTimeout = 1000;
    private byte[] response;
    private final Connection<T> c;
    private final Logger logger;
    private final Function<byte[], T> generator;
    private static final long txInterframeSpacing = 30L;
    private long tsLastTx;
    private static final int peiSwitch_req = 169;
    private static final int cemiServerObjectType = 8;
    private static final int objectInstance = 1;
    static final int pidCommMode = 52;
    static final int DataLinkLayer = 0;
    static final int Busmonitor = 1;
    static final int BaosMode = 240;
    static final int NoLayer = 255;

    static boolean isEmi1GetValue(int messageCode) {
        return messageCode == 75;
    }

    BcuSwitcher(Connection<T> c, Logger l, Function<byte[], T> frameGenerator) {
        this.c = c;
        this.logger = l;
        this.generator = frameGenerator;
        c.addConnectionListener(e -> this.setResponse(e.getFrameBytes()));
    }

    void enter(BcuMode mode) throws KNXFormatException, KNXPortClosedException, KNXTimeoutException, InterruptedException {
        KNXListener l = e -> this.setResponse(e.getFrameBytes());
        this.c.addConnectionListener(l);
        try {
            byte[] data = this.read(BcuSwitcher.createGetValue(265, 1));
            this.logger.info("PEI type {}", (Object)(data[0] & 0xFF));
            data = this.read(BcuSwitcher.createGetValue(278, 1));
            this.logger.debug("Address Table location {}", (Object)DataUnitBuilder.toHex(data, ""));
            data = this.read(BcuSwitcher.createGetValue(96, 1));
            this.logger.debug("Current operation mode {}", (Object)OperationMode.of(data[0] & 0xFF));
            this.writeVerify(265, new byte[]{1});
            this.setExtBusmon(mode == BcuMode.ExtBusmonitor);
            OperationMode set = mode == BcuMode.LinkLayer ? OperationMode.LinkLayer : OperationMode.Busmonitor;
            this.writeVerify(96, new byte[]{(byte)set.mode});
            this.writeVerify(278, new byte[1]);
            data = this.read(BcuSwitcher.createGetValue(279, 2));
            this.logger.info("KNX individual address " + new IndividualAddress(data));
        }
        finally {
            this.c.removeConnectionListener(l);
        }
    }

    void reset() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        this.write(BcuSwitcher.createSetValue(96, new byte[]{(byte)OperationMode.Reset.mode}));
    }

    private static byte[] createSetValue(int address, byte[] data) {
        if (data.length > 15) {
            throw new KNXIllegalArgumentException("data length exceeds maximum of 15 bytes");
        }
        byte[] frame = new byte[4 + data.length];
        frame[0] = 70;
        frame[1] = (byte)data.length;
        frame[2] = (byte)(address >> 8);
        frame[3] = (byte)address;
        int i = 0;
        while (i < data.length) {
            frame[i + 4] = data[i];
            ++i;
        }
        return frame;
    }

    private static byte[] createGetValue(int address, int length) {
        byte[] frame = new byte[]{76, (byte)length, (byte)(address >> 8), (byte)address};
        return frame;
    }

    private static byte[] dataOfGetValueCon(byte[] frame) throws KNXFormatException {
        if (frame.length < 4) {
            throw new KNXFormatException("frame too short for Get-Value.con", frame.length);
        }
        int mc = frame[0] & 0xFF;
        if (mc != 75) {
            throw new KNXFormatException("no Get-Value.con message", mc);
        }
        int length = frame[1] & 0xFF;
        if (length + 4 != frame.length) {
            throw new KNXFormatException("invalid length for frame size " + frame.length, length);
        }
        byte[] data = new byte[length];
        int i = 0;
        while (i < length) {
            data[i] = frame[4 + i];
            ++i;
        }
        return data;
    }

    private void setExtBusmon(boolean ext) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        byte[] data = this.read(BcuSwitcher.createGetValue(257, 1));
        this.logger.debug("Base configuration flags {}", (Object)Integer.toBinaryString(data[0] & 0xFF));
        int config = data[0] & 0xFF;
        config = ext ? (config &= 0xFFFFFFF7) : (config |= 8);
        this.writeVerify(257, new byte[]{(byte)config});
    }

    private byte[] read(byte[] frame) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        this.write(frame);
        return BcuSwitcher.dataOfGetValueCon(this.waitForResponse());
    }

    private void write(byte[] frame) throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        long now = System.currentTimeMillis();
        long wait = 30L - now + this.tsLastTx;
        if (wait > 0L) {
            this.logger.trace("enforce transmission interframe spacing, wait {} ms", (Object)wait);
            Thread.sleep(wait);
        }
        this.tsLastTx = now;
        try {
            this.c.send(this.generator.apply(frame), Connection.BlockingMode.Confirmation);
        }
        catch (KNXTimeoutException | KNXPortClosedException e) {
            throw e;
        }
        catch (KNXException notThrown) {
            notThrown.printStackTrace();
        }
    }

    private boolean writeVerify(int address, byte[] data) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        this.write(BcuSwitcher.createSetValue(address, data));
        byte[] read = this.read(BcuSwitcher.createGetValue(address, data.length));
        boolean equal = Arrays.equals(data, read);
        if (!equal) {
            this.logger.error("verify write failed for address " + Integer.toHexString(address) + ": " + DataUnitBuilder.toHex(data, "") + " vs " + DataUnitBuilder.toHex(read, ""));
        }
        return equal;
    }

    private synchronized byte[] waitForResponse() throws KNXTimeoutException, InterruptedException {
        long remaining = 1000L;
        long end = System.currentTimeMillis() + remaining;
        while (remaining > 0L) {
            if (this.response != null) {
                byte[] r = this.response;
                this.response = null;
                return r;
            }
            this.wait(remaining);
            remaining = end - System.currentTimeMillis();
        }
        throw new KNXTimeoutException("expected service confirmation msg code 0x" + Integer.toHexString(75));
    }

    private synchronized void setResponse(byte[] frame) {
        int msgCode = frame[0] & 0xFF;
        if (msgCode == 75) {
            this.response = frame;
            this.notify();
        }
    }

    static CEMIDevMgmt cemiCommModeRequest(int commMode) {
        return new CEMIDevMgmt(246, 8, 1, 52, 1, 1, new byte[]{(byte)commMode});
    }

    static byte[] commModeRequest(int commMode) {
        return BcuSwitcher.cemiCommModeRequest(commMode).toByteArray();
    }

    void normalMode(boolean cEMI) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        byte[] switchNormal = new byte[]{-87, 30, 18, 52, 86, 120, -102};
        this.switchLayer(cEMI, 255, switchNormal);
    }

    void linkLayerMode(boolean cEMI) throws KNXException {
        byte[] byArray = new byte[7];
        byArray[0] = -87;
        byArray[2] = 24;
        byArray[3] = 52;
        byArray[4] = 86;
        byArray[5] = 120;
        byArray[6] = 10;
        byte[] switchLinkLayer = byArray;
        this.switchLayer(cEMI, 0, switchLinkLayer);
    }

    void baosMode(boolean cEMI) throws KNXException {
        byte[] byArray = new byte[7];
        byArray[0] = -87;
        byArray[2] = 18;
        byArray[3] = 52;
        byArray[4] = 86;
        byArray[5] = 120;
        byArray[6] = -102;
        byte[] normalMode = byArray;
        this.switchLayer(cEMI, 240, normalMode);
    }

    void enterBusmonitor(boolean cEMI) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        byte[] switchBusmon = new byte[]{-87, -112, 24, 52, 86, 120, 10};
        this.switchLayer(cEMI, 1, switchBusmon);
    }

    void leaveBusmonitor(boolean cEMI) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        this.normalMode(cEMI);
    }

    private void switchLayer(boolean cEMI, int cemiCommMode, byte[] peiSwitch) throws KNXTimeoutException, KNXPortClosedException, KNXLinkClosedException {
        try {
            this.c.send(this.generator.apply(cEMI ? BcuSwitcher.commModeRequest(cemiCommMode) : peiSwitch), Connection.BlockingMode.Confirmation);
        }
        catch (InterruptedException e) {
            this.c.close();
            Thread.currentThread().interrupt();
            throw new KNXLinkClosedException(e.getMessage() != null ? e.getMessage() : "thread interrupted");
        }
        catch (KNXAckTimeoutException e) {
            this.c.close();
            throw e;
        }
        catch (KNXTimeoutException | KNXPortClosedException e) {
            throw e;
        }
        catch (KNXException notThrown) {
            notThrown.printStackTrace();
        }
    }

    static enum BcuMode {
        Normal,
        LinkLayer,
        Busmonitor,
        ExtBusmonitor;

    }

    static enum OperationMode {
        Busmonitor(144),
        LinkLayer(18),
        TransportLayer(150),
        ApplicationLayer(30),
        Reset(192);

        final int mode;

        private OperationMode(int mode) {
            this.mode = mode;
        }

        static OperationMode of(int mode) {
            for (OperationMode v : EnumSet.allOf(OperationMode.class)) {
                if (v.mode != mode) continue;
                return v;
            }
            throw new KNXIllegalArgumentException("invalid operation mode 0x" + Integer.toHexString(mode));
        }
    }
}

