/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link;

import java.util.EnumSet;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.link.AbstractMonitor;
import tuwien.auto.calimero.link.BcuSwitcher;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.usb.HidReport;
import tuwien.auto.calimero.serial.usb.TransferProtocolHeader;
import tuwien.auto.calimero.serial.usb.UsbConnection;

public class KNXNetworkMonitorUsb
extends AbstractMonitor<UsbConnection> {
    private static final int PEI_SWITCH = 169;
    private final EnumSet<UsbConnection.EmiType> emiTypes;
    private UsbConnection.EmiType activeEmi;

    public KNXNetworkMonitorUsb(int vendorId, int productId, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new UsbConnection(vendorId, productId), settings);
    }

    public KNXNetworkMonitorUsb(String device, KNXMediumSettings settings) throws KNXException, InterruptedException {
        this(new UsbConnection(device), settings);
    }

    protected KNXNetworkMonitorUsb(UsbConnection c, KNXMediumSettings settings) throws KNXException, InterruptedException {
        super(c, c.name(), settings);
        try {
            if (!((UsbConnection)this.conn).isKnxConnectionActive()) {
                throw new KNXLinkClosedException("USB interface is not connected to KNX network");
            }
            this.emiTypes = ((UsbConnection)this.conn).getSupportedEmiTypes();
            if (!(this.trySetActiveEmi(UsbConnection.EmiType.CEmi) || this.trySetActiveEmi(UsbConnection.EmiType.Emi2) || this.trySetActiveEmi(UsbConnection.EmiType.Emi1))) {
                throw new KNXLinkClosedException("failed to set active any supported EMI type");
            }
            try {
                DeviceDescriptor.DD0 dd0 = ((UsbConnection)this.conn).deviceDescriptor();
                this.logger.info("Device Descriptor (Mask Version) {}", (Object)dd0);
            }
            catch (KNXTimeoutException kNXTimeoutException) {}
            boolean extBusmon = settings instanceof PLSettings;
            this.enterBusmonitor(extBusmon);
        }
        catch (KNXException e) {
            this.close();
            throw e;
        }
        this.logger.info("in busmonitor mode - ready to receive");
        ((UsbConnection)this.conn).addConnectionListener(this.notifier);
    }

    private boolean trySetActiveEmi(UsbConnection.EmiType active) throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        if (this.emiTypes.contains((Object)active)) {
            ((UsbConnection)this.conn).setActiveEmiType(active);
            this.activeEmi = ((UsbConnection)this.conn).getActiveEmiType();
            return this.activeEmi == active;
        }
        return false;
    }

    private void enterBusmonitor(boolean extBusmon) throws KNXPortClosedException, KNXTimeoutException, KNXFormatException, InterruptedException {
        if (this.activeEmi == UsbConnection.EmiType.CEmi) {
            byte[] frame2 = BcuSwitcher.commModeRequest(1);
            ((UsbConnection)this.conn).send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame2).get(0), true);
        } else if (this.activeEmi == UsbConnection.EmiType.Emi1) {
            new BcuSwitcher<HidReport>((Connection)this.conn, this.logger, frame -> HidReport.create(TransferProtocolHeader.KnxTunnelEmi.Emi1, frame).get(0)).enter(extBusmon ? BcuSwitcher.BcuMode.ExtBusmonitor : BcuSwitcher.BcuMode.Busmonitor);
        } else {
            byte[] switchBusmon = new byte[]{-87, -112, 24, 52, 86, 120, 10};
            ((UsbConnection)this.conn).send(HidReport.create(this.activeEmi.emi, switchBusmon).get(0), true);
        }
    }

    @Override
    protected void leaveBusmonitor() throws InterruptedException {
        try {
            this.normalMode();
        }
        catch (KNXTimeoutException | KNXPortClosedException kNXException) {}
    }

    private void normalMode() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        if (this.activeEmi == UsbConnection.EmiType.CEmi) {
            CEMIDevMgmt frame2 = new CEMIDevMgmt(241);
            ((UsbConnection)this.conn).send(HidReport.create(TransferProtocolHeader.KnxTunnelEmi.CEmi, frame2.toByteArray()).get(0), true);
        } else if (this.activeEmi == UsbConnection.EmiType.Emi1) {
            new BcuSwitcher<HidReport>((Connection)this.conn, this.logger, frame -> HidReport.create(TransferProtocolHeader.KnxTunnelEmi.Emi1, frame).get(0)).reset();
        } else if (this.activeEmi == UsbConnection.EmiType.Emi2) {
            byte[] switchNormal = new byte[]{-87, 30, 18, 52, 86, 120, -102};
            ((UsbConnection)this.conn).send(HidReport.create(this.activeEmi.emi, switchNormal).get(0), true);
        }
    }
}

