/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import java.io.ByteArrayInputStream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.link.medium.RawFrameBase;

public class PL110LData
extends RawFrameBase {
    private static final int MIN_LENGTH = 7;
    private final boolean skipDoA;

    public PL110LData(byte[] data, int offset, boolean extBusmon) throws KNXFormatException {
        ByteArrayInputStream is = this.asStream(data, offset, 7, "L-data");
        int len = this.init(is, extBusmon);
        if (this.ext && len > 64) {
            throw new KNXFormatException("APDU length exceeds maximum of 64 bytes", len);
        }
        this.tpdu = new byte[len + 1];
        if (is.read(this.tpdu, 0, this.tpdu.length) != this.tpdu.length) {
            throw new KNXFormatException("data too short for L-data TPDU");
        }
        this.fcs = is.read();
        if (extBusmon) {
            this.skipDoA = false;
        } else {
            this.doa = new byte[2];
            this.skipDoA = is.read(this.doa, 1, 1) == -1;
        }
    }

    public final byte[] getDomainAddress() {
        return (byte[])this.doa.clone();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + (this.skipDoA ? "" : " DoA 0x" + Integer.toHexString(this.doa[1] & 0xFF)) + ", tpdu " + DataUnitBuilder.toHex(this.tpdu, " ");
    }
}

