/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public class PLSettings
extends KNXMediumSettings {
    private static final byte[] broadcastDomain = new byte[2];
    private byte[] doa;

    public PLSettings() {
        super(BackboneRouter);
        this.doa = broadcastDomain;
    }

    public PLSettings(IndividualAddress device, byte[] domain) {
        super(device);
        this.setDomainAddress(domain);
    }

    public final synchronized void setDomainAddress(byte[] domain) {
        if (domain == null) {
            this.doa = broadcastDomain;
        } else {
            if (domain.length != 2) {
                throw new KNXIllegalArgumentException("invalid length of domain address");
            }
            this.doa = (byte[])domain.clone();
        }
    }

    public final synchronized byte[] getDomainAddress() {
        return (byte[])this.doa.clone();
    }

    @Override
    public int getMedium() {
        return 4;
    }

    @Override
    public int timeFactor() {
        return 390;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " in domain 0x" + Integer.toHexString((this.doa[0] & 0xFF) << 8 | this.doa[1] & 0xFF);
    }
}

