/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.LteHeeTag;
import tuwien.auto.calimero.cemi.RFMediumInfo;
import tuwien.auto.calimero.link.medium.RawFrame;

public class RFLData
implements RawFrame {
    private static final int MinLength = 20;
    private static final int ReservedLength = 255;
    private static final int Send_NoReply = 68;
    private static final int Escape = 255;
    private static final int TpduOffset = 15;
    private static final int Block2TpduSize = 10;
    private final int length;
    private final RFMediumInfo.RSS rss;
    private final boolean batteryOk;
    private final boolean unidir;
    private final int ctrl;
    private final byte[] doa;
    private final IndividualAddress src;
    private final KNXAddress dst;
    private final int maxRep;
    private final int lfn;
    private final boolean isDoA;
    private final byte[] tpdu;

    static RFLData newForTransmitOnlyDevice(boolean batteryOk, int frameType, int frameNumber, byte[] serial, GroupAddress dst, byte[] tpdu) {
        return new RFLData(batteryOk, true, frameType, frameNumber, serial, new IndividualAddress(1535), dst, tpdu);
    }

    public RFLData(boolean batteryOk, boolean transmitOnlyDevice, int frameType, int frameNumber, byte[] doa, IndividualAddress src, KNXAddress dst, byte[] tpdu) {
        this.length = 15 + tpdu.length;
        this.rss = RFMediumInfo.RSS.Void;
        this.batteryOk = batteryOk;
        this.unidir = transmitOnlyDevice;
        this.doa = (byte[])doa.clone();
        this.ctrl = frameType;
        this.src = src;
        this.dst = dst;
        this.maxRep = 6;
        this.lfn = frameNumber;
        boolean grpbcast = dst instanceof GroupAddress && dst.getRawAddress() == 0;
        this.isDoA = grpbcast || dst instanceof IndividualAddress;
        this.tpdu = (byte[])tpdu.clone();
    }

    public RFLData(byte[] frame, int offset) throws KNXFormatException {
        boolean lteExt;
        ByteArrayInputStream is = new ByteArrayInputStream(frame, offset, frame.length - offset);
        if (is.available() < 20) {
            throw new KNXFormatException("minimum data length < 20", is.available());
        }
        this.length = is.read();
        if (this.length == 255) {
            throw new KNXFormatException("unsupported RF frame length", 255);
        }
        int c = is.read();
        if (c != 68) {
            throw new KNXFormatException("no KNX RF L-Data frame");
        }
        int esc = is.read();
        if (esc != 255) {
            throw new KNXFormatException("invalid Escape field", esc);
        }
        int info = is.read();
        int hi = info & 0xF0;
        if (hi != 0) {
            throw new KNXFormatException("invalid RF info field", info);
        }
        int rssvalue = info >>> 2 & 3;
        this.rss = RFMediumInfo.RSS.values()[rssvalue];
        this.batteryOk = (info & 2) == 2;
        this.unidir = (info & 1) == 1;
        this.doa = new byte[6];
        is.read(this.doa, 0, this.doa.length);
        int crc1 = is.read() << 8 | is.read();
        RFLData.verifyCrc(crc1, frame, offset, 10);
        this.ctrl = is.read();
        if (this.ctrl == 255) {
            throw new KNXFormatException("unsupported KNX control field (Escape)");
        }
        int extFormat = this.ctrl & 0xF;
        boolean std = extFormat == 0;
        boolean bl = lteExt = (extFormat & 0xC) == 4;
        if (!std && !lteExt) {
            throw new KNXFormatException("unsupported frame format", extFormat);
        }
        byte[] addr = new byte[2];
        is.read(addr, 0, 2);
        this.src = new IndividualAddress(addr);
        is.read(addr, 0, 2);
        int lpci = is.read();
        boolean group = (lpci & 0x80) == 128;
        this.maxRep = lpci >>> 4 & 7;
        this.lfn = lpci >>> 1 & 7;
        this.isDoA = (lpci & 1) == 1;
        this.dst = group ? new GroupAddress(addr) : new IndividualAddress(addr);
        int tpduSize = this.length - 15;
        if (tpduSize < 0) {
            throw new KNXFormatException("invalid RF L-Data length, TPDU size < 0", this.length);
        }
        this.tpdu = new byte[tpduSize];
        is.read(this.tpdu, 0, Math.min(10, tpduSize));
        int pci = this.tpdu[0] & 0xFF;
        int tpci = pci >>> 6;
        if (lteExt && tpci != Tpci.UnnumberedData.ordinal()) {
            throw new KNXFormatException("RF LTE extended frame requires TPCI " + (Object)((Object)Tpci.UnnumberedData));
        }
        int crc2 = is.read() << 8 | is.read();
        int block2Size = Math.min(10, tpduSize) + 6;
        RFLData.verifyCrc(crc2, frame, offset + 12, block2Size);
        int block = 3;
        int got = 10;
        while (got < tpduSize) {
            int read = Math.min(16, tpduSize - got);
            byte[] part = new byte[read];
            int res = is.read(part, 0, part.length);
            if (res != read) {
                throw new KNXFormatException("truncated RF frame in block " + block + ": length " + got + " < expected total length " + this.length + " bytes");
            }
            System.arraycopy(part, 0, this.tpdu, got, read);
            int crcn = is.read() << 8 | is.read();
            RFLData.verifyCrc(crcn, frame, offset + (block - 1) * 18 - 6, read);
            ++block;
            got += 16;
        }
    }

    public final IndividualAddress getSource() {
        return this.src;
    }

    public final KNXAddress getDestination() {
        return this.dst;
    }

    @Override
    public final int getFrameType() {
        return this.ctrl;
    }

    public final RFMediumInfo.RSS getRss() {
        return this.rss;
    }

    public final boolean isBatteryOk() {
        return this.batteryOk;
    }

    public final boolean isTransmitOnlyDevice() {
        return this.unidir;
    }

    public boolean isSystemBroadcast() {
        return !this.isDoA;
    }

    public final byte[] getDoAorSN() {
        return (byte[])this.doa.clone();
    }

    public final int getFrameNumber() {
        return this.lfn;
    }

    public final byte[] getTpdu() {
        return (byte[])this.tpdu.clone();
    }

    public final byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.length);
        os.write(68);
        os.write(255);
        int info = this.rss.ordinal() << 2 | (this.batteryOk ? 2 : 0) | (this.unidir ? 1 : 0);
        os.write(info);
        os.write(this.doa, 0, this.doa.length);
        os.write(RFLData.crc(os.toByteArray(), 0), 0, 2);
        os.write(this.ctrl);
        os.write(this.src.toByteArray(), 0, 2);
        os.write(this.dst.toByteArray(), 0, 2);
        int lpci = this.dst instanceof GroupAddress ? 128 : 0;
        os.write(lpci |= this.maxRep << 4 | this.lfn << 1 | (this.isDoA ? 1 : 0));
        int min = Math.min(10, this.tpdu.length);
        os.write(this.tpdu, 0, min);
        int i = min;
        while (i < 10) {
            os.write(0);
            ++i;
        }
        byte[] crc2 = RFLData.crc(os.toByteArray(), 12);
        os.write(crc2, 0, 2);
        int written = 10;
        while (written < this.tpdu.length) {
            int write = Math.min(16, this.tpdu.length - written);
            os.write(this.tpdu, written, write);
            byte[] crcn = RFLData.crc(this.tpdu, written, write);
            os.write(crcn, 0, 2);
            written += 16;
        }
        return os.toByteArray();
    }

    public String toString() {
        boolean lteExt;
        StringBuilder sb = new StringBuilder();
        boolean bl = lteExt = (this.ctrl & 0xC) == 4;
        if (lteExt) {
            sb.append("LTE ");
        }
        sb.append(RFLData.getFrameType(this.ctrl >>> 4));
        sb.append(" ").append(this.src).append("->");
        if (lteExt) {
            sb.append(LteHeeTag.from(this.ctrl, (GroupAddress)this.dst));
        } else {
            sb.append(this.dst);
        }
        sb.append(this.isSystemBroadcast() ? " SN " : " DoA ").append(DataUnitBuilder.toHex(this.getDoAorSN(), ""));
        sb.append(", RSS=").append((Object)this.getRss());
        sb.append(" Battery ").append(this.isBatteryOk() ? "OK" : "weak");
        sb.append(", LFN ").append(this.getFrameNumber());
        sb.append(": ").append(DataUnitBuilder.toHex(this.tpdu, ""));
        return sb.toString();
    }

    private static String getFrameType(int format) {
        switch (format) {
            case 0: {
                return "L-Data (async)";
            }
            case 1: {
                return "Fast ACK";
            }
            case 4: {
                return "L-Data (sync)";
            }
            case 5: {
                return "BiBat Sync";
            }
            case 6: {
                return "BiBat Help Call";
            }
            case 7: {
                return "BiBat Help Call Res";
            }
            case 8: {
                return "RF Multi L-Data (async)";
            }
            case 9: {
                return "RF Multi L-Data (async, ACK.req)";
            }
            case 10: {
                return "RF Multi Repeater ACK";
            }
        }
        return "Reserved";
    }

    private static void verifyCrc(int crc, byte[] data, int offset, int length) throws KNXFormatException {
        int calc = RFLData.crc16(data, offset, length);
        if (calc != crc) {
            throw new KNXFormatException("CRC mismatch, expected 0x" + Integer.toHexString(crc) + " vs calculated 0x" + Integer.toHexString(calc));
        }
    }

    private static byte[] crc(byte[] data, int offset) {
        return RFLData.crc(data, offset, data.length - offset);
    }

    private static byte[] crc(byte[] data, int offset, int length) {
        int crc = RFLData.crc16(data, offset, length);
        return new byte[]{(byte)(crc >> 8), (byte)crc};
    }

    static int crc16(byte[] data, int offset, int length) {
        int crc = 0;
        int i = offset;
        while (i < offset + length) {
            int bite = data[i] & 0xFF;
            int b = 8;
            while (b-- > 0) {
                boolean bit = (bite >> b & 1) == 1;
                boolean one = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(one ^ bit)) continue;
                crc ^= 0x13D65;
            }
            ++i;
        }
        return ~crc & 0xFFFF;
    }

    static enum FrameType {
        AsyncLData,
        RfMultiAsyncLData,
        RfMultiAsyncLDataAckReq,
        FastAck;

    }

    public static enum Tpci {
        UnnumberedData,
        NumberedData,
        UnnumberedCtrl,
        NumberedCtrl;

    }
}

