/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import java.io.ByteArrayInputStream;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.LteHeeTag;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.link.medium.RawFrame;

public abstract class RawFrameBase
implements RawFrame {
    protected int type;
    protected byte[] doa;
    protected IndividualAddress src;
    protected KNXAddress dst;
    protected boolean ext;
    protected boolean repetition;
    protected Priority p;
    protected int hopcount;
    protected int fcs;
    protected byte[] tpdu;
    private int eff;

    @Override
    public final int getFrameType() {
        return this.type;
    }

    public final IndividualAddress getSource() {
        return this.src;
    }

    public final KNXAddress getDestination() {
        return this.dst;
    }

    public final Priority getPriority() {
        return this.p;
    }

    public final int getHopcount() {
        return this.hopcount;
    }

    public final boolean isRepetition() {
        return this.repetition;
    }

    public final byte[] getTPDU() {
        return this.tpdu == null ? null : (byte[])this.tpdu.clone();
    }

    public final int getChecksum() {
        return this.fcs;
    }

    public String toString() {
        boolean lte = this.ext && (this.eff & 4) == 4;
        KNXAddress dstAddr = lte ? LteHeeTag.from(this.eff, (GroupAddress)this.dst) : this.dst;
        StringBuilder sb = new StringBuilder();
        sb.append(this.src).append("->").append(dstAddr);
        sb.append(this.type == 0 ? " L-Data" : " L-Polldata").append(".req");
        if (this.ext) {
            sb.append(" (ext)");
        }
        sb.append(", ").append((Object)this.p).append(" priority");
        if (this.repetition) {
            sb.append(" repeat");
        }
        sb.append(" FCS 0x").append(Integer.toHexString(this.fcs));
        return sb.toString();
    }

    ByteArrayInputStream asStream(byte[] data, int offset, int minLength, String type) throws KNXFormatException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, data.length - offset);
        int avail = is.available();
        if (avail < minLength) {
            throw new KNXFormatException("data too short for " + type + " frame", avail);
        }
        return is;
    }

    int init(ByteArrayInputStream is, boolean parseDoA) throws KNXFormatException {
        int len;
        int ctrl = is.read();
        if ((ctrl & 0x53) != 16) {
            throw new KNXFormatException("invalid control field", ctrl);
        }
        this.type = 0;
        this.ext = (ctrl & 0x80) == 0;
        this.repetition = (ctrl & 0x20) == 0;
        this.p = Priority.get(ctrl >> 2 & 3);
        int ctrle = this.ext ? this.readCtrlEx(is) : 0;
        this.eff = ctrle & 0xF;
        if (parseDoA) {
            this.doa = new byte[2];
            is.read(this.doa, 0, 2);
        }
        this.src = new IndividualAddress(is.read() << 8 | is.read());
        int addr = is.read() << 8 | is.read();
        int npci = is.read();
        if (this.ext) {
            this.hopcount = (ctrle & 0x70) >> 4;
            this.setDestination(addr, (ctrle & 0x80) != 0);
            len = npci;
        } else {
            this.hopcount = (npci & 0x70) >> 4;
            this.setDestination(addr, (npci & 0x80) != 0);
            len = npci & 0xF;
        }
        return len;
    }

    void setDestination(int addr, boolean group) {
        this.dst = group ? new GroupAddress(addr) : new IndividualAddress(addr);
    }

    int readCtrlEx(ByteArrayInputStream is) {
        int ctrle = is.read();
        return ctrle;
    }
}

