/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.link.medium.PL110Ack;
import tuwien.auto.calimero.link.medium.PL110LData;
import tuwien.auto.calimero.link.medium.RFLData;
import tuwien.auto.calimero.link.medium.RawFrame;
import tuwien.auto.calimero.link.medium.TP1Ack;
import tuwien.auto.calimero.link.medium.TP1LData;
import tuwien.auto.calimero.link.medium.TP1LPollData;

public final class RawFrameFactory {
    private RawFrameFactory() {
    }

    public static RawFrame create(int mediumType, byte[] data, int offset, boolean extBusmon) throws KNXFormatException {
        switch (mediumType) {
            case 2: {
                return RawFrameFactory.createTP1(data, offset);
            }
            case 4: {
                return RawFrameFactory.createPL110(data, offset, extBusmon);
            }
            case 16: {
                return new RFLData(data, offset);
            }
        }
        throw new KNXFormatException("unknown KNX medium for raw frame", mediumType);
    }

    public static RawFrame createTP1(byte[] data, int offset) throws KNXFormatException {
        int ctrl = data[offset] & 0xFF;
        if ((ctrl & 0x10) == 16) {
            if ((ctrl & 0x40) == 0) {
                return new TP1LData(data, offset);
            }
            if (ctrl == 240) {
                return new TP1LPollData(data, offset);
            }
            throw new KNXFormatException("invalid raw frame control field", ctrl);
        }
        return new TP1Ack(data, offset);
    }

    public static RawFrame createPL110(byte[] data, int offset, boolean extBusmon) throws KNXFormatException {
        if ((data[0] & 0x10) == 16) {
            return new PL110LData(data, offset, extBusmon);
        }
        return new PL110Ack(data, offset);
    }
}

