/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.link.medium;

import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.link.medium.RawAckBase;

public class TP1Ack
extends RawAckBase {
    public static final int BUSY = 192;
    public static final int NAK_BUSY = 0;

    public TP1Ack(byte[] data, int offset) throws KNXFormatException {
        int ctrl = data[offset] & 0xFF;
        if ((ctrl & 0x33) != 0) {
            throw new KNXFormatException("no TP1 ACK frame, invalid control field", ctrl);
        }
        if (ctrl == 204) {
            this.ack = 204;
        } else if (ctrl == 12) {
            this.ack = 12;
        } else if (ctrl == 192) {
            this.ack = 192;
        } else if (ctrl == 0) {
            this.ack = 0;
        } else {
            throw new KNXFormatException("no valid acknowledge type", ctrl);
        }
    }

    @Override
    public String toString() {
        return this.ack == 192 ? "BUSY" : (this.ack == 0 ? "NAK-BUSY" : super.toString());
    }
}

