/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.mgmt.PropertyAdapter;

abstract class LocalDeviceManagement<T>
implements PropertyAdapter {
    private static final int DEVICE_OBJECT = 0;
    protected final Connection<T> c;
    private final Consumer<CloseEvent> adapterClosed;
    private final Deque<CEMI> frames = new ArrayDeque<CEMI>();
    private volatile boolean serverReset;
    private final List<Integer> interfaceObjects = new ArrayList<Integer>();
    private final boolean checkRW;
    private volatile boolean closed;
    private int lastObjIndex;
    private int lastPropIndex;
    private int lastPid;

    LocalDeviceManagement(Connection<T> connection, Consumer<CloseEvent> adapterClosed, boolean queryWriteEnable) {
        this.c = connection;
        this.adapterClosed = adapterClosed;
        this.checkRW = queryWriteEnable;
    }

    void init() throws KNXException, InterruptedException {
        this.resetLastDescription();
        try {
            this.initInterfaceObjects();
        }
        catch (KNXException e) {
            try {
                this.c.close();
            }
            catch (Exception exception) {}
            throw e;
        }
    }

    public final List<Integer> interfaceObjects() {
        return List.copyOf(this.interfaceObjects);
    }

    @Override
    public void setProperty(int objIndex, int pid, int start, int elements, byte ... data) throws KNXException, InterruptedException {
        if (this.closed) {
            throw new IllegalStateException("adapter closed");
        }
        int objectType = this.getObjectType(objIndex);
        int objectInstance = this.getObjectInstance(objIndex, objectType);
        CEMIDevMgmt req = new CEMIDevMgmt(246, objectType, objectInstance, pid, start, elements, data);
        this.send(req, Connection.BlockingMode.Confirmation);
        this.findFrame(245, req);
    }

    @Override
    public byte[] getProperty(int objIndex, int pid, int start, int elements) throws KNXException, InterruptedException {
        if (this.closed) {
            throw new IllegalStateException("adapter closed");
        }
        int objectType = this.getObjectType(objIndex);
        int objectInstance = this.getObjectInstance(objIndex, objectType);
        CEMIDevMgmt req = new CEMIDevMgmt(252, objectType, objectInstance, pid, start, elements);
        this.send(req, Connection.BlockingMode.Confirmation);
        return this.findFrame(251, req);
    }

    @Override
    public byte[] getDescription(int objIndex, int pid, int propIndex) throws KNXException, InterruptedException {
        if (pid != 0 || objIndex != this.lastObjIndex || propIndex < this.lastPropIndex) {
            this.resetLastDescription();
        }
        byte[] ret = null;
        int p = pid;
        if (p == 0) {
            p = this.lastPid;
            int i = this.lastPropIndex;
            while (p < 255 && i < propIndex) {
                try {
                    ret = this.getProperty(objIndex, ++p, 0, 1);
                    ++i;
                }
                catch (KNXRemoteException kNXRemoteException) {}
            }
            if (i != propIndex) {
                this.resetLastDescription();
                throw new KNXRemoteException("can't deduce property index in object");
            }
            this.setLastDescription(objIndex, i, p);
        } else {
            ret = this.getProperty(objIndex, p, 0, 1);
        }
        int writeEnabled = 0;
        if (this.checkRW) {
            try {
                this.setProperty(objIndex, p, 0, 1, ret);
                writeEnabled = 128;
            }
            catch (KNXRemoteException kNXRemoteException) {}
        }
        byte[] byArray = new byte[7];
        byArray[0] = (byte)objIndex;
        byArray[1] = (byte)p;
        byArray[2] = (byte)propIndex;
        byArray[3] = (byte)writeEnabled;
        return byArray;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.c.close();
            }
            catch (Exception exception) {}
        }
    }

    protected abstract void send(CEMIDevMgmt var1, Connection.BlockingMode var2) throws KNXException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] findFrame(int messageCode, CEMIDevMgmt request) throws KNXRemoteException, InterruptedException {
        CEMIDevMgmt frame;
        while (true) {
            Deque<CEMI> deque = this.frames;
            synchronized (deque) {
                if (this.frames.isEmpty()) {
                    throw new KNXInvalidResponseException(String.format("confirmation expected (msg code 0x%x)", messageCode));
                }
                frame = (CEMIDevMgmt)this.frames.remove();
            }
            int mc = frame.getMessageCode();
            if (mc == 240) {
                this.serverReset = true;
                this.close();
                throw new KNXRemoteException("received reset indication from server, connection closed");
            }
            if (mc != messageCode || frame.getObjectType() != request.getObjectType() || frame.getObjectInstance() != request.getObjectInstance() || frame.getPID() != request.getPID()) continue;
            if (frame.isNegativeResponse()) {
                throw new KNXRemoteException(frame.getErrorMessage());
            }
            if (frame.getElementCount() == request.getElementCount()) break;
        }
        return frame.getPayload();
    }

    protected int getObjectType(int objIndex) throws KNXRemoteException {
        if (objIndex < this.interfaceObjects.size()) {
            return this.interfaceObjects.get(objIndex);
        }
        throw new KNXRemoteException("interface object with index " + objIndex + " not listed");
    }

    private int getObjectInstance(int objIndex, int objectType) {
        int instance = 0;
        int i = 0;
        while (i <= objIndex) {
            if (this.interfaceObjects.get(i) == objectType) {
                ++instance;
            }
            ++i;
        }
        return instance;
    }

    protected void initInterfaceObjects() throws KNXException, InterruptedException {
        CEMIDevMgmt req = new CEMIDevMgmt(252, 0, 1, 71, 0, 1);
        this.send(req, Connection.BlockingMode.Confirmation);
        int objects = 0;
        try {
            byte[] ret = this.findFrame(251, req);
            objects = (ret[0] & 0xFF) << 8 | ret[1] & 0xFF;
        }
        catch (KNXRemoteException kNXRemoteException) {
            this.interfaceObjects.add(0);
            this.interfaceObjects.add(8);
            return;
        }
        CEMIDevMgmt req2 = new CEMIDevMgmt(252, 0, 1, 71, 1, objects);
        this.send(req2, Connection.BlockingMode.Confirmation);
        byte[] ret = this.findFrame(251, req2);
        int i = 0;
        while (i < objects) {
            int objType = (ret[2 * i] & 0xFF) << 8 | ret[2 * i + 1] & 0xFF;
            this.interfaceObjects.add(objType);
            ++i;
        }
    }

    private void resetLastDescription() {
        this.lastObjIndex = -1;
        this.lastPropIndex = -1;
        this.lastPid = 0;
    }

    private void setLastDescription(int oi, int pi, int pid) {
        this.lastObjIndex = oi;
        this.lastPropIndex = pi;
        this.lastPid = pid;
    }

    protected final class KNXListenerImpl
    implements KNXListener {
        protected KNXListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void frameReceived(FrameEvent e) {
            if (e.getFrame() instanceof CEMIDevMgmt) {
                Deque<CEMI> deque = LocalDeviceManagement.this.frames;
                synchronized (deque) {
                    LocalDeviceManagement.this.frames.add(e.getFrame());
                }
            }
        }

        @Override
        public void connectionClosed(CloseEvent e) {
            LocalDeviceManagement.this.closed = true;
            int initiator = LocalDeviceManagement.this.serverReset ? 1 : e.getInitiator();
            LocalDeviceManagement.this.adapterClosed.accept(new CloseEvent(LocalDeviceManagement.this, initiator, LocalDeviceManagement.this.serverReset ? "server reset" : e.getReason()));
        }
    }
}

