/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.KNXnetIPDevMgmt;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.mgmt.LocalDeviceManagement;

public class LocalDeviceManagementIp
extends LocalDeviceManagement<CEMI> {
    private final InetSocketAddress remote;

    public static LocalDeviceManagementIp newAdapter(TcpConnection connection, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        KNXnetIPDevMgmt mgmt = new KNXnetIPDevMgmt(connection);
        return new LocalDeviceManagementIp(mgmt, adapterClosed, false);
    }

    public static LocalDeviceManagementIp newAdapter(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, boolean queryWriteEnable, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        return new LocalDeviceManagementIp(localEP, serverCtrlEP, useNat, adapterClosed, queryWriteEnable);
    }

    public static LocalDeviceManagementIp newSecureAdapter(TcpConnection.SecureSession session, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        KNXnetIPDevMgmt mgmt = SecureConnection.newDeviceManagement(session);
        return new LocalDeviceManagementIp(mgmt, adapterClosed, false);
    }

    public static LocalDeviceManagementIp newSecureAdapter(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, byte[] userKey, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        KNXnetIPDevMgmt mgmt = SecureConnection.newDeviceManagement(localEP, serverCtrlEP, useNat, deviceAuthCode, userKey);
        return new LocalDeviceManagementIp(mgmt, adapterClosed, false);
    }

    protected LocalDeviceManagementIp(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, Consumer<CloseEvent> adapterClosed, boolean queryWriteEnable) throws KNXException, InterruptedException {
        this(LocalDeviceManagementIp.create(localEP, serverCtrlEP, useNat), adapterClosed, queryWriteEnable);
    }

    LocalDeviceManagementIp(KNXnetIPConnection mgmt, Consumer<CloseEvent> adapterClosed, boolean queryWriteEnable) throws KNXException, InterruptedException {
        super(mgmt, adapterClosed, queryWriteEnable);
        this.remote = mgmt.getRemoteAddress();
        this.c.addConnectionListener(new LocalDeviceManagement.KNXListenerImpl());
        this.init();
    }

    public void reset() throws KNXException, InterruptedException {
        this.send(new CEMIDevMgmt(241), Connection.BlockingMode.Ack);
    }

    @Override
    public String getName() {
        return "Local-DM " + this.remote.getAddress().getHostAddress() + ":" + this.remote.getPort();
    }

    @Override
    protected void send(CEMIDevMgmt frame, Connection.BlockingMode mode) throws KNXException, InterruptedException {
        this.c.send(frame, mode);
    }

    private static KNXnetIPDevMgmt create(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat) throws KNXException, InterruptedException {
        return new KNXnetIPDevMgmt(localEP, serverCtrlEP, useNat);
    }
}

