/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Settings;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator2ByteUnsigned;
import tuwien.auto.calimero.dptxlator.PropertyTypes;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.LocalDeviceManagement;
import tuwien.auto.calimero.mgmt.PropertyAccess;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlOutputFactory;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class PropertyClient
implements PropertyAccess,
AutoCloseable {
    private static final String[] OBJECT_TYPE_NAMES = new String[]{"Device Object", "Addresstable Object", "Associationtable Object", "Applicationprogram Object", "Applicationprogram 2 Object", "KNX-Object Associationtable Object", "Router Object", "LTE Address Filter Table Object", "cEMI Server Object", "Group Object Table Object", "Polling Master", "KNXnet/IP Parameter Object", "Application Controller", "File Server Object", "", "", "", "Security Object", "", "RF Medium Object"};
    private final Map<PropertyKey, Property> properties = Collections.synchronizedMap(new HashMap());
    private final PropertyAdapter pa;
    private final boolean local;
    private final Logger logger;
    private final List<Pair> objectTypes = new ArrayList<Pair>();
    private final DPTXlator2ByteUnsigned tObjType;

    public PropertyClient(PropertyAdapter adapter) throws KNXFormatException {
        this.pa = adapter;
        this.local = adapter instanceof LocalDeviceManagement || this.pa.getName().toLowerCase().startsWith("local");
        try {
            this.tObjType = new DPTXlator2ByteUnsigned(DPTXlator2ByteUnsigned.DPT_PROP_DATATYPE);
        }
        catch (KNXFormatException e) {
            this.pa.close();
            throw e;
        }
        this.logger = LogService.getLogger("calimero.mgmt.PC " + this.pa.getName());
    }

    public static String getObjectTypeName(int objType) {
        if (objType < OBJECT_TYPE_NAMES.length) {
            return OBJECT_TYPE_NAMES[objType];
        }
        return "";
    }

    public void addDefinitions(Collection<Property> definitions) {
        for (Property p : definitions) {
            this.properties.put(new PropertyKey(p.objType, p.id), p);
        }
    }

    public Map<PropertyKey, Property> getDefinitions() {
        return this.properties;
    }

    @Override
    public void setProperty(int objIndex, int pid, int position, String value) throws KNXException, InterruptedException {
        DPTXlator t = this.createTranslator(objIndex, pid);
        t.setValue(value);
        this.setProperty(objIndex, pid, position, t.getItems(), t.getData());
    }

    public String getProperty(int objIndex, int pid) throws KNXException, InterruptedException {
        return this.getPropertyTranslated(objIndex, pid, 1, 1).getValue();
    }

    @Override
    public void setProperty(int objIndex, int pid, int start, int elements, byte ... data) throws KNXException, InterruptedException {
        this.pa.setProperty(objIndex, pid, start, elements, data);
    }

    @Override
    public byte[] getProperty(int objIndex, int pid, int start, int elements) throws KNXException, InterruptedException {
        return this.pa.getProperty(objIndex, pid, start, elements);
    }

    @Override
    public DPTXlator getPropertyTranslated(int objIndex, int pid, int start, int elements) throws KNXException, InterruptedException {
        DPTXlator t = this.createTranslator(objIndex, pid);
        t.setData(this.getProperty(objIndex, pid, start, elements));
        return t;
    }

    @Override
    public Description getDescription(int objIndex, int pid) throws KNXException, InterruptedException {
        if (pid == 0) {
            throw new KNXIllegalArgumentException("pid has to be > 0");
        }
        return this.createDesc(objIndex, this.pa.getDescription(objIndex, pid, 0));
    }

    @Override
    public Description getDescriptionByIndex(int objIndex, int propIndex) throws KNXException, InterruptedException {
        return this.createDesc(objIndex, this.pa.getDescription(objIndex, 0, propIndex));
    }

    public void scanProperties(boolean allProperties, Consumer<Description> consumer) throws KNXException, InterruptedException {
        int index = 0;
        while (this.scan(index, allProperties, consumer) > 0) {
            ++index;
        }
    }

    public void scanProperties(int objIndex, boolean allProperties, Consumer<Description> consumer) throws KNXException, InterruptedException {
        this.scan(objIndex, allProperties, consumer);
    }

    public final boolean isOpen() {
        return this.pa.isOpen();
    }

    @Override
    public void close() {
        if (this.pa.isOpen()) {
            this.pa.close();
            this.logger.info("closed property client");
        }
    }

    private int scan(int objIndex, boolean allProperties, Consumer<Description> consumer) throws KNXException, InterruptedException {
        int i;
        block7: {
            i = 0;
            if (allProperties) break block7;
            consumer.accept(this.createDesc(objIndex, this.pa.getDescription(objIndex, 1, 0)));
            return 1;
        }
        try {
            while (true) {
                try {
                    consumer.accept(this.createDesc(objIndex, this.pa.getDescription(objIndex, 0, i)));
                }
                catch (KNXTimeoutException kNXTimeoutException) {
                    consumer.accept(this.createDesc(objIndex, this.pa.getDescription(objIndex, 0, i)));
                }
                ++i;
            }
        }
        catch (KNXException e) {
            if (!KNXRemoteException.class.equals(e.getClass()) && !KNXTimeoutException.class.equals(e.getClass())) {
                this.logger.error("scan properties failed", (Throwable)e);
                throw e;
            }
            return i;
        }
    }

    private Description createDesc(int oi, byte[] desc) throws KNXException, InterruptedException {
        int pid = desc[1] & 0xFF;
        byte[] data = new byte[4];
        try {
            data = this.pa.getProperty(oi, pid, 0, 1);
        }
        catch (KNXRemoteException e) {
            this.logger.warn("failed to get current number of elements for OI {} PID {}: {}", new Object[]{oi, pid, e.getMessage()});
        }
        Description d = new Description(this.getObjectType(oi, true), Description.parseCurrentElements(data), desc);
        if (this.local) {
            d.setPDT(-1);
        }
        return d;
    }

    private int getObjectType(int objIndex, boolean queryObject) throws KNXException, InterruptedException {
        for (Pair p : this.objectTypes) {
            if (p.oindex != objIndex) continue;
            return p.otype;
        }
        if (queryObject) {
            return this.queryObjectType(objIndex);
        }
        throw new KNXException("couldn't deduce object type");
    }

    private int queryObjectType(int objIndex) throws KNXException, InterruptedException {
        if (this.pa instanceof LocalDeviceManagement) {
            LocalDeviceManagement ldm = (LocalDeviceManagement)this.pa;
            int ot = ldm.getObjectType(objIndex);
            this.objectTypes.add(new Pair(objIndex, ot));
            return ot;
        }
        byte[] objectType = this.pa.getProperty(objIndex, 1, 1, 1);
        this.tObjType.setData(objectType);
        this.objectTypes.add(new Pair(objIndex, this.tObjType.getValueUnsigned()));
        return this.tObjType.getValueUnsigned();
    }

    private DPTXlator createTranslator(int objIndex, int pid) throws KNXException, InterruptedException {
        int ot = this.getObjectType(objIndex, true);
        int pdt = -1;
        Property p = this.properties.get(new PropertyKey(ot, pid));
        if (p == null && pid <= 50) {
            p = this.properties.get(new PropertyKey(pid));
        }
        if (p != null) {
            if (p.dpt != null) {
                try {
                    DPTXlator t = TranslatorTypes.createTranslator(0, p.dpt);
                    t.setAppendUnit(false);
                    return t;
                }
                catch (KNXException e) {
                    this.logger.warn("fallback to default translator for PID " + pid + ", no translator for DPT " + p.dpt, (Throwable)e);
                }
            }
            pdt = p.pdt;
        }
        if (pdt == -1 && !this.local) {
            pdt = this.pa.getDescription(objIndex, pid, 0)[3] & 0x3F;
        }
        if (PropertyTypes.hasTranslator(pdt)) {
            DPTXlator t = PropertyTypes.createTranslator(pdt);
            t.setAppendUnit(false);
            return t;
        }
        throw new KNXException("no translator available for PID " + pid + " in " + PropertyClient.getObjectTypeName(ot) + " (OT " + ot + "), PDT " + pdt + " ");
    }

    private static final class Pair {
        final int oindex;
        final int otype;

        Pair(int objIndex, int objType) {
            this.oindex = objIndex;
            this.otype = objType;
        }
    }

    public static class Property {
        final int id;
        final String name;
        final String propName;
        final String description;
        final int objType;
        final int pdt;
        final String dpt;
        final int read;
        final int write;
        final int accessPolicy;

        public Property(int pid, String pidName, String propertyName, int objectType, int pdt, String dpt) {
            this(pid, pidName, propertyName, "n/a", objectType, pdt, dpt, 0, 0, 0);
        }

        Property(int pid, String pidName, String propertyName, String description, int objectType, int pdt, String dpt, int readLevel, int writeLevel, int accessPolicy) {
            this.id = pid;
            this.name = pidName;
            this.propName = propertyName;
            this.description = description;
            this.objType = objectType;
            this.pdt = pdt;
            this.dpt = dpt;
            this.read = readLevel;
            this.write = writeLevel;
            this.accessPolicy = accessPolicy;
        }

        public final int getPID() {
            return this.id;
        }

        public final String getPIDName() {
            return this.name;
        }

        public final int getObjectType() {
            return this.objType;
        }

        public final int getPDT() {
            return this.pdt;
        }

        public final Optional<String> dpt() {
            return Optional.ofNullable(this.dpt);
        }

        public final String getName() {
            return this.propName;
        }

        public final String description() {
            return this.description;
        }

        public final boolean readOnly() {
            return this.write == -1;
        }

        public final int writeLevel() {
            return this.write;
        }

        public final int readLevel() {
            return this.read;
        }

        public final int accessPolicy() {
            return this.accessPolicy;
        }

        public String toString() {
            return String.valueOf(this.name) + " (" + this.id + ") '" + this.propName + "'" + (this.objType == -1 ? "" : " OT " + this.objType) + " PDT " + this.pdt + this.dpt().map(s -> " DPT " + s).orElse("") + " r/w " + this.read + "/" + (this.readOnly() ? "-" : Integer.valueOf(this.write)) + this.accessPolicyString();
        }

        private String accessPolicyString() {
            if (this.accessPolicy == 0) {
                return "";
            }
            return String.format(" %03x/%03x", this.accessPolicy >> 10, this.accessPolicy & 0x3FF);
        }
    }

    public static final class PropertyKey
    implements Comparable<PropertyKey> {
        public static final int GLOBAL_OBJTYPE = -1;
        private final int ot;
        private final int id;

        public PropertyKey(int pid) {
            this.ot = -1;
            this.id = pid;
        }

        public PropertyKey(int objType, int pid) {
            this.ot = objType;
            this.id = pid;
        }

        public int getPID() {
            return this.id;
        }

        public boolean isGlobal() {
            return this.ot == -1;
        }

        public int hashCode() {
            return this.ot << 16 | this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropertyKey) {
                PropertyKey key = (PropertyKey)obj;
                return this.ot == key.ot && this.id == key.id;
            }
            return false;
        }

        @Override
        public int compareTo(PropertyKey o) {
            int rhs = o.hashCode();
            return this.hashCode() < rhs ? -1 : (this.hashCode() > rhs ? 1 : 0);
        }

        public String toString() {
            return String.valueOf(PropertyClient.getObjectTypeName(this.ot)) + " PID " + this.id;
        }
    }

    public static interface ResourceHandler {
        public Collection<Property> load(String var1) throws KNXMLException;

        public Collection<Property> load(XmlReader var1) throws KNXMLException;

        public void save(String var1, Collection<Property> var2) throws KNXMLException;

        public void save(XmlWriter var1, Collection<Property> var2) throws KNXMLException;
    }

    public static class XmlPropertyDefinitions
    implements ResourceHandler {
        private static final String PROPDEFS_TAG = "propertyDefinitions";
        private static final String OBJECT_TAG = "object";
        private static final String OBJECTTYPE_ATTR = "type";
        private static final String PROPERTY_TAG = "property";
        private static final String PID_ATTR = "pid";
        private static final String PIDNAME_ATTR = "pidName";
        private static final String NAME_ATTR = "name";
        private static final String PDT_ATTR = "pdt";
        private static final String DPT_ATTR = "dpt";
        private static final String RW_ATTR = "rw";
        private static final String WRITE_ATTR = "writeEnabled";
        private static final String USAGE_TAG = "usage";

        @Override
        public Collection<Property> load(String resource) throws KNXMLException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (XmlReader r = XmlInputFactory.newInstance().createXMLReader(resource);){
                return this.load(r);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<Property> load(XmlReader reader) throws KNXMLException {
            ArrayList<Property> list = new ArrayList<Property>();
            int objType = -1;
            try {
                if (reader.nextTag() != 1) throw new KNXMLException("no property defintions");
                if (!reader.getLocalName().equals(PROPDEFS_TAG)) {
                    throw new KNXMLException("no property defintions");
                }
                while (true) {
                    if (!reader.hasNext()) {
                        return list;
                    }
                    int event = reader.next();
                    if (event == 1) {
                        if (reader.getLocalName().equals(OBJECT_TAG)) {
                            String type = reader.getAttributeValue("", OBJECTTYPE_ATTR);
                            objType = "global".equals(type) ? -1 : XmlPropertyDefinitions.toInt(type);
                            continue;
                        }
                        if (!reader.getLocalName().equals(PROPERTY_TAG)) continue;
                        int pid = XmlPropertyDefinitions.toInt(reader.getAttributeValue("", PID_ATTR));
                        String pidName = reader.getAttributeValue("", PIDNAME_ATTR);
                        String friendly = reader.getAttributeValue("", NAME_ATTR);
                        int pdt = XmlPropertyDefinitions.toInt(reader.getAttributeValue("", PDT_ATTR));
                        String dpt = reader.getAttributeValue("", DPT_ATTR);
                        int[] rw = XmlPropertyDefinitions.parseRW(reader.getAttributeValue("", RW_ATTR));
                        boolean write = XmlPropertyDefinitions.parseWriteEnabled(reader.getAttributeValue("", WRITE_ATTR));
                        int accessPolicy = XmlPropertyDefinitions.parseAccessPolicy(reader.getAttributeValue("", "accessPolicy"));
                        String description = "";
                        if (reader.nextTag() == 1 && reader.getLocalName().equals(USAGE_TAG)) {
                            description = reader.getElementText();
                        }
                        list.add(new Property(pid, pidName, friendly, description, objType, pdt, dpt, rw[0], write ? rw[1] : -1, accessPolicy));
                        continue;
                    }
                    if (event == 2 && reader.getLocalName().equals(PROPDEFS_TAG)) break;
                }
                return list;
            }
            catch (KNXFormatException e) {
                throw new KNXMLException("loading property definitions, " + e.getMessage());
            }
        }

        @Override
        public void save(String resource, Collection<Property> definitions) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (XmlWriter w = XmlOutputFactory.newInstance().createXMLWriter(resource);){
                w.writeStartDocument("UTF-8", "1.0");
                this.save(w, definitions);
                w.writeEndDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public void save(XmlWriter writer, Collection<Property> definitions) {
            writer.writeComment("Calimero v" + Settings.getLibraryVersion() + " KNX property definitions, saved on " + ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
            writer.writeStartElement(PROPDEFS_TAG);
            int objType = -2;
            for (Property p : definitions) {
                if (p.objType != objType) {
                    if (objType != -2) {
                        writer.writeEndElement();
                    }
                    objType = p.objType;
                    writer.writeStartElement(OBJECT_TAG);
                    writer.writeAttribute(OBJECTTYPE_ATTR, objType == -1 ? "global" : Integer.toString(objType));
                }
                writer.writeStartElement(PROPERTY_TAG);
                writer.writeAttribute(PID_ATTR, Integer.toString(p.id));
                writer.writeAttribute(PIDNAME_ATTR, p.name);
                writer.writeAttribute(NAME_ATTR, p.propName);
                writer.writeAttribute(PDT_ATTR, p.pdt == -1 ? "<tbd>" : Integer.toString(p.pdt));
                if (p.dpt != null && p.dpt.length() > 0) {
                    writer.writeAttribute(DPT_ATTR, p.dpt);
                }
                writer.writeAttribute(RW_ATTR, String.format("%d/%d", p.read, p.write));
                writer.writeAttribute(WRITE_ATTR, p.readOnly() ? "0" : "1");
                writer.writeStartElement(USAGE_TAG);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private static int[] parseRW(String rw) {
            String s = rw.toLowerCase();
            int read = 0;
            int write = 0;
            boolean slash = false;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == '/') {
                    slash = true;
                } else if (c >= '0' && c <= '9') {
                    if (slash) {
                        write = write * 10 + c - 48;
                    } else {
                        read = read * 10 + c - 48;
                    }
                } else if (c == 'r') {
                    read = 3;
                } else if (c == 'w') {
                    write = 3;
                }
                ++i;
            }
            return new int[]{read, write};
        }

        private static boolean parseWriteEnabled(String attribute) {
            String s = attribute.toLowerCase();
            if ("0".equals(s) || "false".equals(s)) {
                return false;
            }
            if ("1".equals(s) || "true".equals(s)) {
                return true;
            }
            return "w".equals(s);
        }

        private static int parseAccessPolicy(String attribute) throws KNXFormatException {
            if (attribute == null || attribute.isEmpty()) {
                return 0;
            }
            int slash = attribute.indexOf(47);
            int off = Integer.parseInt(attribute.substring(0, slash), 16);
            int on = Integer.parseInt(attribute.substring(slash + 1), 16);
            if (off > 1023 || on > 1023) {
                throw new KNXFormatException("invalid access policy", attribute);
            }
            return off << 10 | on;
        }

        private static int toInt(String s) throws KNXFormatException {
            block3: {
                block4: {
                    try {
                        if (s == null) break block3;
                        if (!s.equals("<tbd>") && !s.equals("-")) break block4;
                        return -1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return s.length() == 0 ? 0 : Integer.decode(s);
            }
            throw new KNXFormatException("cannot convert to number", s);
        }
    }
}

