/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.mgmt;

import java.util.Objects;
import java.util.function.Consumer;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.ManagementClientImpl;
import tuwien.auto.calimero.mgmt.PropertyAdapter;

public class RemotePropertyServiceAdapter
implements PropertyAdapter {
    private final ManagementClient mc;
    private final Destination dst;
    private byte[] key;
    private volatile int accessLevel;
    private final NetworkLinkListener nll = new NLListener();
    private final Consumer<CloseEvent> adapterClosed;

    public RemotePropertyServiceAdapter(KNXNetworkLink link, IndividualAddress remote, Consumer<CloseEvent> adapterClosed, boolean connOriented) throws KNXLinkClosedException {
        this.mc = new ManagementClientImpl(link);
        this.dst = this.mc.createDestination(remote, connOriented);
        this.adapterClosed = Objects.requireNonNull(adapterClosed);
        link.addLinkListener(this.nll);
        this.key = null;
        this.accessLevel = 15;
    }

    public RemotePropertyServiceAdapter(KNXNetworkLink link, IndividualAddress remote, Consumer<CloseEvent> adapterClosed, byte[] authorizeKey) throws KNXException, InterruptedException {
        this(link, remote, adapterClosed, true);
        this.key = (byte[])authorizeKey.clone();
        try {
            this.accessLevel = this.mc.authorize(this.dst, this.key);
        }
        catch (KNXException e) {
            this.close();
            throw e;
        }
    }

    public final int accessLevel() {
        return this.accessLevel;
    }

    public ManagementClient managementClient() {
        return this.mc;
    }

    public Destination destination() {
        return this.dst;
    }

    @Override
    public void setProperty(int objIndex, int pid, int start, int elements, byte ... data) throws KNXException, InterruptedException {
        this.mc.writeProperty(this.dst, objIndex, pid, start, elements, data);
    }

    @Override
    public byte[] getProperty(int objIndex, int pid, int start, int elements) throws KNXException, InterruptedException {
        return this.mc.readProperty(this.dst, objIndex, pid, start, elements);
    }

    @Override
    public byte[] getDescription(int objIndex, int pid, int propIndex) throws KNXException, InterruptedException {
        return this.mc.readPropertyDesc(this.dst, objIndex, pid, propIndex);
    }

    @Override
    public String getName() {
        return "remote PS " + this.dst.getAddress();
    }

    @Override
    public boolean isOpen() {
        return this.mc.isOpen();
    }

    @Override
    public void close() {
        KNXNetworkLink lnk = this.mc.detach();
        if (lnk != null) {
            lnk.removeLinkListener(this.nll);
        }
    }

    private final class NLListener
    implements NetworkLinkListener {
        private NLListener() {
        }

        @Override
        public void linkClosed(CloseEvent e) {
            RemotePropertyServiceAdapter.this.adapterClosed.accept(new CloseEvent(RemotePropertyServiceAdapter.this, e.getInitiator(), e.getReason()));
        }
    }
}

