/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.process;

import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessEvent;

public final class LteProcessEvent
extends ProcessEvent {
    private static final long serialVersionUID = 1L;
    private final int extFrameFormat;

    public LteProcessEvent(ProcessCommunicator source, IndividualAddress src, int extFrameFormat, GroupAddress tag, byte[] tpdu) {
        super(source, src, tag, DataUnitBuilder.getAPDUService(tpdu), DataUnitBuilder.extractASDU(tpdu), false);
        int pci = tpdu[0] & 0xFF;
        int tpci = pci >>> 6;
        if (tpci != 0) {
            throw new KnxRuntimeException("LTE extended frame requires TPCI 0");
        }
        this.extFrameFormat = extFrameFormat;
    }

    public int extFrameFormat() {
        return this.extFrameFormat;
    }
}

