/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.secure;

import java.util.Objects;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public final class SecurityControl {
    private final DataSecurity security;
    private final boolean toolAccess;
    private final boolean systemBroadcast;
    public static final SecurityControl Plain = new SecurityControl(DataSecurity.None);
    public static final SecurityControl SystemBroadcast = new SecurityControl(DataSecurity.AuthConf, true, true);

    public static SecurityControl of(DataSecurity security, boolean toolAccess) {
        if (security == DataSecurity.None) {
            if (toolAccess) {
                throw new KNXIllegalArgumentException("tool access requires security");
            }
            return Plain;
        }
        return new SecurityControl(security, toolAccess, false);
    }

    private SecurityControl(DataSecurity security) {
        this(security, false, false);
    }

    private SecurityControl(DataSecurity security, boolean toolAccess, boolean systemBroadcast) {
        this.security = security;
        this.toolAccess = toolAccess;
        this.systemBroadcast = systemBroadcast;
    }

    public DataSecurity security() {
        return this.security;
    }

    public boolean toolAccess() {
        return this.toolAccess;
    }

    public boolean systemBroadcast() {
        return this.systemBroadcast;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.security, this.toolAccess});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SecurityControl)) {
            return false;
        }
        SecurityControl sc = (SecurityControl)obj;
        return this.security == sc.security && this.toolAccess == sc.toolAccess;
    }

    public String toString() {
        return (Object)((Object)this.security) + (this.toolAccess ? ", tool access" : "");
    }

    public static enum DataSecurity {
        None,
        Auth,
        AuthConf;


        public String toString() {
            return this == AuthConf ? "auth+conf" : super.toString().toLowerCase();
        }
    }
}

