/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.serial.SerialComAdapter;
import tuwien.auto.calimero.serial.spi.SerialCom;

public class LibraryAdapter {
    private static final List<String> defaultPortPrefixes = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("windows") > -1 ? List.of("\\\\.\\COM") : List.of("/dev/ttyS", "/dev/ttyACM", "/dev/ttyUSB", "/dev/ttyAMA");

    static List<String> defaultPortPrefixes() {
        return defaultPortPrefixes;
    }

    public static List<String> getPortIdentifiers() {
        for (ServiceLoader.Provider provider : SerialComLoader.providers(false).collect(Collectors.toList())) {
            try {
                SerialCom inst = (SerialCom)provider.get();
                return inst.portIdentifiers();
            }
            catch (ServiceConfigurationError e) {
                Throwable ex = e.getCause() != null ? e.getCause() : e;
                LoggerFactory.getLogger((String)"calimero.serial").debug("skip service provider {}", (Object)provider.type().getName(), (Object)ex);
            }
        }
        return List.of();
    }

    public static SerialCom open(Logger logger, String portId, int baudrate, int idleTimeout) throws KNXException {
        Throwable t = null;
        for (ServiceLoader.Provider provider : SerialComLoader.providers(false).collect(Collectors.toList())) {
            try {
                return LibraryAdapter.open(provider, logger, portId, baudrate, idleTimeout);
            }
            catch (ServiceConfigurationError e) {
                Throwable ex = e.getCause() != null ? e.getCause() : e;
                logger.debug("skip service provider {}: {}", (Object)provider.type().getName(), (Object)ex.getMessage());
            }
            catch (Throwable e) {
                t = e;
            }
        }
        if (t instanceof KNXException) {
            throw (KNXException)t;
        }
        if (t != null) {
            throw new KNXException("failed to open serial port " + portId, t);
        }
        throw new KNXException("no serial provider available to open " + portId);
    }

    private static SerialCom open(ServiceLoader.Provider<SerialCom> provider, Logger logger, String portId, int baudrate, int idleTimeout) throws Throwable {
        SerialCom inst = provider.get();
        logger.debug("open serial communication provider {}", (Object)provider.type().getName());
        inst.open(portId);
        try {
            inst.setSerialPortParams(baudrate, 8, SerialCom.StopBits.One, SerialCom.Parity.Even);
            inst.setFlowControlMode(SerialCom.FlowControl.None);
            if (provider.type().equals(SerialComAdapter.class)) {
                SerialComAdapter conn = (SerialComAdapter)inst;
                conn.setTimeouts(new SerialComAdapter.Timeouts(idleTimeout, 0, 5, 0, 0));
            }
        }
        catch (IOException | RuntimeException e) {
            inst.close();
            throw e;
        }
        logger.debug("serial port setup: {}", (Object)inst);
        return inst;
    }

    private static class SerialComLoader {
        private static final ServiceLoader<SerialCom> loader = ServiceLoader.load(SerialCom.class);

        private SerialComLoader() {
        }

        static Stream<ServiceLoader.Provider<SerialCom>> providers(boolean refresh) {
            if (refresh) {
                loader.reload();
            }
            return loader.stream();
        }
    }
}

