/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.serial.LibraryAdapter;
import tuwien.auto.calimero.serial.PortInputStream;
import tuwien.auto.calimero.serial.PortOutputStream;
import tuwien.auto.calimero.serial.spi.SerialCom;

public class SerialComAdapter
implements SerialCom {
    static final int BAUDRATE = 1;
    static final int PARITY = 2;
    static final int DATABITS = 3;
    static final int STOPBITS = 4;
    static final int FLOWCTRL = 5;
    static final int FLOWCTRL_NONE = 0;
    static final int FLOWCTRL_CTSRTS = 1;
    static final int PARITY_NONE = 0;
    static final int PARITY_ODD = 1;
    static final int PARITY_EVEN = 2;
    static final int PARITY_MARK = 3;
    static final int ONE_STOPBIT = 1;
    static final int TWO_STOPBITS = 2;
    static final int AVAILABLE_INPUT_STATUS = 2;
    private static final int ERROR_STATUS = 1;
    private static final int LINE_STATUS = 3;
    private static final int EVENT_RXCHAR = 1;
    private static final int EVENT_RXFLAG = 2;
    private static final int EVENT_TXEMPTY = 4;
    private static final int EVENT_CTS = 8;
    private static final int EVENT_DSR = 16;
    private static final int EVENT_RLSD = 32;
    private static final int EVENT_BREAK = 64;
    private static final int EVENT_ERR = 128;
    private static final int EVENT_RING = 256;
    private static final boolean loaded;
    private static final int INVALID_HANDLE = -1;
    private long fd = -1L;
    private final ReentrantLock lock = new ReentrantLock();
    private InputStream is;
    private OutputStream os;
    private final Logger logger;

    static {
        boolean b = false;
        try {
            LoggerFactory.getLogger((String)"calimero.serial").trace("check Java library path {}", (Object)System.getProperty("java.library.path"));
            System.loadLibrary("serialcom");
            b = true;
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            LoggerFactory.getLogger((String)"calimero.serial").debug(e.getMessage());
        }
        loaded = b;
    }

    public SerialComAdapter() {
        if (!loaded) {
            throw new KnxRuntimeException("no serialcom library found");
        }
        this.logger = LoggerFactory.getLogger((String)"calimero.serial");
    }

    static native boolean portExists(String var0);

    @Override
    public List<String> portIdentifiers() {
        if (!loaded) {
            return List.of();
        }
        ArrayList<String> ports = new ArrayList<String>();
        LibraryAdapter.defaultPortPrefixes().forEach(p -> IntStream.range(0, 20).mapToObj(i -> String.valueOf(p) + i).filter(SerialComAdapter::portExists).forEach(ports::add));
        return ports;
    }

    native int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    native int write(int var1) throws IOException;

    native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    native int read() throws IOException;

    @Override
    public void setSerialPortParams(int baudrate, int databits, SerialCom.StopBits stopbits, SerialCom.Parity parity) throws IOException {
        this.setControl(1, baudrate);
        this.setControl(3, 8);
        this.setControl(4, stopbits.value());
        this.setControl(2, parity.value());
    }

    @Override
    public void setFlowControlMode(SerialCom.FlowControl mode) throws IOException {
        this.setControl(5, mode.value());
    }

    native void setTimeouts(Timeouts var1) throws IOException;

    native Timeouts getTimeouts() throws IOException;

    @Override
    public int baudRate() throws IOException {
        return this.getControl(1);
    }

    native int getStatus(int var1);

    native int setControl(int var1, int var2) throws IOException;

    native int getControl(int var1) throws IOException;

    @Override
    public InputStream inputStream() {
        this.lock.lock();
        try {
            if (this.is == null) {
                this.is = new PortInputStream(this);
            }
            InputStream inputStream = this.is;
            return inputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public OutputStream outputStream() {
        this.lock.lock();
        try {
            if (this.os == null) {
                this.os = new PortOutputStream(this);
            }
            OutputStream outputStream = this.os;
            return outputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void close() {
        try {
            if (this.fd != -1L) {
                this.close0();
            }
        }
        catch (IOException e) {
            this.logger.error("closing serial port", (Throwable)e);
        }
        this.fd = -1L;
    }

    public String toString() {
        if (this.fd == -1L) {
            return "closed";
        }
        try {
            return "baudrate " + this.baudRate() + ", even parity, " + this.getControl(3) + " databits, " + this.getControl(4) + " stopbits, timeouts: " + this.getTimeouts();
        }
        catch (IOException iOException) {
            return "invalid port setup";
        }
    }

    private native void setEvents(int var1, boolean var2) throws IOException;

    private native int waitEvent() throws IOException;

    @Override
    public native void open(String var1) throws IOException;

    private native void close0() throws IOException;

    static final class Timeouts {
        final int readInterval;
        final int readTotalMultiplier;
        final int readTotalConstant;
        final int writeTotalMultiplier;
        final int writeTotalConstant;

        Timeouts(int readInterval, int readTotalMultiplier, int readTotalConstant, int writeTotalMultiplier, int writeTotalConstant) {
            this.readInterval = readInterval;
            this.readTotalMultiplier = readTotalMultiplier;
            this.readTotalConstant = readTotalConstant;
            this.writeTotalMultiplier = writeTotalMultiplier;
            this.writeTotalConstant = writeTotalConstant;
        }

        public String toString() {
            return "read " + this.readInterval + " read total " + this.readTotalMultiplier + " constant " + this.readTotalConstant + " write total " + this.writeTotalMultiplier + " write constant " + this.writeTotalConstant;
        }
    }
}

