/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAckTimeoutException;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIBusMon;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.LibraryAdapter;
import tuwien.auto.calimero.serial.spi.SerialCom;

public class TpuartConnection
implements Connection<byte[]> {
    private static final int Reset_req = 1;
    private static final int Reset_ind = 3;
    private static final int State_req = 2;
    private static final int State_ind = 7;
    private static final int ActivateBusmon = 5;
    private static final int LData_con = 11;
    private static final int AckInfo = 16;
    private static final int LDataStart = 128;
    private static final int LDataEnd = 64;
    private static final int AlwaysSet = 16;
    private static final int StdFrameFormat = 144;
    private static final int ExtFrameFormat = 16;
    private static final int RepeatFlag = 32;
    private static final int Ack = 204;
    private static final int Nak = 12;
    private static final int Busy = 192;
    private static final int OK = 0;
    private static final int ConPending = 1;
    private static final long UartStateReadInterval = 5000000L;
    private static final int UartBaudRate = 19200;
    private static final int Tp1BaudRate = 9600;
    private static final int OneBitTime = (int)Math.ceil(104.16666666666667);
    private static final int BitTimes_50 = 50 * OneBitTime;
    private static final int MaxSendAttempts = 4;
    private final String portId;
    private final SerialCom adapter;
    private final OutputStream os;
    private final InputStream is;
    private final Receiver receiver;
    private final Object lock = new Object();
    private volatile boolean idle;
    private final Object enterIdleLock = new Object();
    private volatile byte[] req;
    private volatile int state;
    private volatile boolean busmon;
    private volatile int busmonSequence;
    private final EventListeners<KNXListener> listeners = new EventListeners();
    private final Set<KNXAddress> addresses = Collections.synchronizedSet(new HashSet());
    private final Map<KNXAddress, Long> sending = new ConcurrentHashMap<KNXAddress, Long>();
    private final Logger logger;
    private static final AtomicInteger maxInterByteDelay = new AtomicInteger(BitTimes_50);

    static {
        try {
            String delay = System.getProperty("calimero.serial.tpuart.maxInterByteDelay");
            if (delay != null) {
                int value = Integer.parseUnsignedInt(delay);
                maxInterByteDelay.set(value);
                LoggerFactory.getLogger((String)"calimero.serial.tpuart").info("using {} of {} us", (Object)"calimero.serial.tpuart.maxInterByteDelay", (Object)value);
            }
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger((String)"calimero.serial.tpuart").warn("on checking property {}", (Object)"calimero.serial.tpuart.maxInterByteDelay", (Object)e);
        }
    }

    public TpuartConnection(String portId, Collection<? extends KNXAddress> acknowledge) throws KNXException {
        this.portId = portId;
        this.logger = LogService.getAsyncLogger("calimero.serial.tpuart:" + portId);
        this.adapter = LibraryAdapter.open(this.logger, portId, 19200, 0);
        this.os = this.adapter.outputStream();
        this.is = this.adapter.inputStream();
        this.addresses.add(GroupAddress.Broadcast);
        this.addresses.addAll(acknowledge);
        this.receiver = new Receiver();
        this.receiver.start();
        try {
            this.reset();
        }
        catch (IOException e) {
            this.closeResources();
            throw new KNXPortClosedException("on resetting TP-UART controller", portId, e);
        }
        if (!this.waitForInitialUartState()) {
            this.closeResources();
            throw new KNXPortClosedException("timeout waiting for initial TP-UART state", portId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForInitialUartState() {
        this.logger.trace("wait for initial TP-UART state");
        long now = System.nanoTime();
        long end = now + 1000000000L;
        try {
            while (true) {
                if (now >= end) {
                    return false;
                }
                if (this.receiver.lastUartState != 0L) {
                    return true;
                }
                Thread.sleep(10L);
                now = System.nanoTime();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    @Override
    public final void addConnectionListener(KNXListener l) {
        this.listeners.add(l);
    }

    @Override
    public final void removeConnectionListener(KNXListener l) {
        this.listeners.remove(l);
    }

    @Override
    public String name() {
        return this.portId;
    }

    public void activateBusmonitor() throws IOException {
        this.logger.debug("activate TP-UART busmonitor");
        this.os.write(5);
        this.busmonSequence = 0;
        this.busmon = true;
    }

    public final void addAddress(KNXAddress ack) {
        this.addresses.add(ack);
    }

    public final void removeAddress(KNXAddress ack) {
        this.addresses.remove(ack);
    }

    @Override
    public void send(byte[] frame, Connection.BlockingMode blockingMode) throws KNXPortClosedException, KNXAckTimeoutException, InterruptedException {
        this.send(frame, blockingMode != Connection.BlockingMode.NonBlocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] frame, boolean waitForCon) throws KNXPortClosedException, KNXAckTimeoutException, InterruptedException {
        try {
            boolean group;
            byte[] tp1Frame = TpuartConnection.cEmiToTP1(frame);
            byte[] data = TpuartConnection.toUartServices(tp1Frame);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("create UART services {}", (Object)DataUnitBuilder.toHex(data, " "));
            }
            this.req = (byte[])frame.clone();
            long coolDownMillis = (this.receiver.coolDownUntil - System.nanoTime()) / 1000000L;
            if (coolDownMillis > 0L) {
                Thread.sleep(coolDownMillis);
            }
            long start = System.nanoTime();
            boolean bl = group = (frame[3] & 0x80) == 128;
            if (group) {
                this.sending.put(new GroupAddress(new byte[]{frame[6], frame[7]}), start);
            }
            boolean logReadyForSending = !this.idle;
            Object object = this.enterIdleLock;
            synchronized (object) {
                while (!this.idle) {
                    this.enterIdleLock.wait();
                }
            }
            if (logReadyForSending) {
                this.logger.trace("UART ready for sending after {} us", (Object)((System.nanoTime() - start) / 1000L));
            }
            this.logger.debug("write UART services, {}", (Object)(waitForCon ? "waiting for .con" : "non-blocking"));
            this.os.write(data);
            this.state = 1;
            if (!waitForCon) {
                return;
            }
            if (this.waitForCon(tp1Frame.length)) {
                return;
            }
            try {
                throw new KNXAckTimeoutException("no ACK for L-Data.con");
            }
            catch (InterruptedIOException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (IOException e) {
                this.close();
                throw new KNXPortClosedException("I/O error", this.portId, e);
            }
        }
        finally {
            this.req = null;
        }
    }

    @Override
    public void close() {
        this.close(0, "user request");
    }

    private void close(int origin, String reason) {
        try {
            this.reset();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {}
        this.closeResources();
        this.fireConnectionClosed(origin, reason);
    }

    private void closeResources() {
        this.receiver.quit();
        this.adapter.close();
    }

    private void fireConnectionClosed(int origin, String reason) {
        CloseEvent ce = new CloseEvent(this, origin, reason);
        this.listeners.fire(l -> l.connectionClosed(ce));
    }

    private void reset() throws IOException {
        this.logger.debug("reset TP-UART controller");
        this.busmon = false;
        this.busmonSequence = 0;
        this.os.write(1);
    }

    private static byte[] cEmiToTP1(byte[] frame) {
        byte[] tp1;
        boolean std;
        int skipToCtrl1 = 2 + frame[1] & 0xFF;
        int cemiPrefix = skipToCtrl1 + 8;
        boolean extended = (frame[skipToCtrl1] & 0x80) == 0;
        boolean bl = std = !extended && frame.length <= cemiPrefix + 15;
        if (std) {
            tp1 = new byte[frame.length - skipToCtrl1];
            int i = 0;
            tp1[i++] = (byte)(frame[skipToCtrl1] & 0xFC | 0x90 | 0x20);
            tp1[i++] = frame[skipToCtrl1 + 2];
            tp1[i++] = frame[skipToCtrl1 + 3];
            tp1[i++] = frame[skipToCtrl1 + 4];
            tp1[i++] = frame[skipToCtrl1 + 5];
            int len = frame[skipToCtrl1 + 6];
            tp1[i++] = (byte)(frame[skipToCtrl1 + 1] & 0xF0 | len);
            tp1[i++] = frame[skipToCtrl1 + 7];
            int k = 0;
            while (k < len) {
                tp1[i++] = frame[cemiPrefix + k];
                ++k;
            }
        } else {
            int length = frame.length - skipToCtrl1 + 1;
            if (length > 64) {
                throw new KNXIllegalArgumentException("L-Data frame length " + length + " > max. 64 bytes for TP-UART");
            }
            tp1 = new byte[length];
            int i = skipToCtrl1;
            while (i < frame.length) {
                tp1[i - skipToCtrl1] = frame[i];
                ++i;
            }
            tp1[0] = (byte)(tp1[0] & 0xFFFFFF6F);
            tp1[0] = (byte)(tp1[0] | 0x30);
        }
        tp1[tp1.length - 1] = (byte)TpuartConnection.checksum(tp1);
        return tp1;
    }

    private static byte[] toUartServices(byte[] tp1) {
        ByteArrayOutputStream data = new ByteArrayOutputStream(tp1.length * 2);
        int i = 0;
        while (i < tp1.length - 1) {
            data.write(0x80 | i);
            data.write(tp1[i]);
            ++i;
        }
        data.write(0x40 | tp1.length - 1);
        data.write(tp1[tp1.length - 1]);
        return data.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForCon(int frameLen) throws InterruptedException {
        boolean rcvdCon;
        int innerFrameChar = 13 * OneBitTime;
        int bitTimes_15 = 15 * OneBitTime;
        int maxExchangeTimeout = 4 * (BitTimes_50 + frameLen * innerFrameChar + 2 * bitTimes_15) / 1000;
        long remaining = maxExchangeTimeout;
        long start = System.currentTimeMillis();
        long end = start + remaining;
        Object object = this.lock;
        synchronized (object) {
            while (this.state == 1 && remaining > 0L) {
                this.lock.wait(remaining);
                remaining = end - System.currentTimeMillis();
            }
        }
        boolean bl = rcvdCon = this.state == 0;
        if (rcvdCon) {
            this.logger.trace("ACK received after {} ms", (Object)((long)maxExchangeTimeout - remaining));
        } else {
            this.logger.debug("no ACK received after {} ms", (Object)(System.currentTimeMillis() - start));
        }
        return rcvdCon;
    }

    private static int checksum(byte[] frame) {
        int cs = 0;
        byte[] byArray = frame;
        int n = frame.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            cs ^= b;
            ++n2;
        }
        return ~cs;
    }

    private boolean isValidChecksum(byte[] frame) {
        boolean valid;
        byte expected = frame[frame.length - 1];
        byte[] copy = Arrays.copyOf(frame, frame.length - 1);
        int cs = TpuartConnection.checksum(copy);
        boolean bl = valid = expected == cs;
        if (!valid) {
            this.logger.warn("invalid L-Data checksum 0x{}, expected 0x{}", (Object)Integer.toHexString(cs & 0xFF), (Object)Integer.toHexString(expected & 0xFF));
        }
        return valid;
    }

    private final class Receiver
    extends Thread {
        private volatile boolean quit;
        private final ByteArrayOutputStream in;
        private long lastRead;
        private boolean extFrame;
        private boolean frameAcked;
        private byte[] lastReceived;
        volatile long lastUartState;
        private boolean uartStatePending;
        private int maxDelay;
        private int consecutiveFrameDrops;
        private long coolDownUntil;

        Receiver() {
            super("Calimero TP-UART receiver");
            this.in = new ByteArrayOutputStream();
            this.lastReceived = new byte[0];
            this.maxDelay = maxInterByteDelay.get();
            this.consecutiveFrameDrops = -1;
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int drained = 0;
            try {
                while (TpuartConnection.this.is.read() != -1) {
                    ++drained;
                }
            }
            catch (IOException iOException) {}
            TpuartConnection.this.logger.trace("drained rx queue ({} bytes)", (Object)drained);
            long enterIdleTimestamp = 0L;
            while (!this.quit) {
                try {
                    long start = System.nanoTime();
                    int c = TpuartConnection.this.is.read();
                    if (c == -1) {
                        this.checkUartState();
                        if (enterIdleTimestamp == 0L) {
                            enterIdleTimestamp = start;
                            continue;
                        }
                        if (this.coolDownUntil > start) {
                            Thread.sleep(1L);
                            continue;
                        }
                        if ((start - enterIdleTimestamp) / 1000L <= 10000L) continue;
                        Object object = TpuartConnection.this.enterIdleLock;
                        synchronized (object) {
                            TpuartConnection.this.idle = true;
                            TpuartConnection.this.enterIdleLock.notify();
                            continue;
                        }
                    }
                    long idlePeriod = (start - enterIdleTimestamp) / 1000L;
                    if (enterIdleTimestamp != 0L && idlePeriod > 100000L) {
                        TpuartConnection.this.logger.trace("receiver woke from extended idle period of {} us", (Object)idlePeriod);
                    }
                    TpuartConnection.this.idle = false;
                    enterIdleTimestamp = 0L;
                    if (!(this.parseFrame(c) || this.isLDataCon(c) || this.isUartStateInd(c) || c != 3)) {
                        this.uartStatePending = false;
                        TpuartConnection.this.logger.debug("TP-UART reset.ind");
                    }
                    long loop = System.nanoTime() - start;
                    TpuartConnection.this.logger.trace("loop time = {} us", (Object)(loop / 1000L));
                }
                catch (RuntimeException e) {
                    TpuartConnection.this.logger.warn("continue after internal error in receiver loop", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException e) {
                    if (this.quit) break;
                    TpuartConnection.this.close(3, "receiver communication failure, " + e.toString());
                    break;
                }
            }
        }

        void quit() {
            this.quit = true;
            this.interrupt();
            if (Receiver.currentThread() == this) {
                return;
            }
            try {
                this.join(50L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        private int maxInterByteDelay() {
            if (this.consecutiveFrameDrops >= 3) {
                this.maxDelay = maxInterByteDelay.accumulateAndGet(Math.min(this.maxDelay + 500, 20000), Math::max);
                TpuartConnection.this.logger.warn("{} partial frames discarded, increase max. inter-byte delay to {} us", (Object)(this.consecutiveFrameDrops + 1), (Object)this.maxDelay);
                this.consecutiveFrameDrops = -1;
            }
            return this.maxDelay;
        }

        private boolean parseFrame(int c) throws IOException {
            int minLength;
            long now = System.nanoTime() / 1000L;
            int size = this.in.size();
            if (size > 0) {
                minLength = this.extFrame ? 7 : 6;
                long diff = now - this.lastRead;
                if (size < minLength && diff > (long)this.maxInterByteDelay()) {
                    this.resetReceiveBuffer(c, diff);
                    size = 0;
                } else if (size >= minLength && diff > (long)(4 * this.maxInterByteDelay())) {
                    this.resetReceiveBuffer(c, diff);
                    size = 0;
                }
            }
            if (size > 0) {
                this.in.write(c);
                this.lastRead = now;
                int n = minLength = this.extFrame ? 7 : 6;
                if (size + 1 >= minLength) {
                    byte[] frame = this.in.toByteArray();
                    this.ack(frame);
                    int total = this.extFrame ? 8 + (frame[6] & 0x3F) + 1 : 7 + (frame[5] & 0xF) + 1;
                    if (frame.length >= total) {
                        try {
                            try {
                                boolean repeated;
                                byte[] data = this.in.toByteArray();
                                TpuartConnection.this.logger.debug("received TP1 L-Data (length {}): {}", (Object)frame.length, (Object)DataUnitBuilder.toHex(data, " "));
                                this.consecutiveFrameDrops = -1;
                                if (TpuartConnection.this.busmon) {
                                    this.fireFrameReceived(this.createBusmonInd(data));
                                }
                                boolean bl = repeated = (data[0] & 0x20) == 0;
                                if (repeated && Arrays.equals(this.lastReceived, 0, this.lastReceived.length - 2, frame, 0, data.length - 2)) {
                                    TpuartConnection.this.logger.debug("ignore repetition of directly preceding correctly received frame");
                                }
                                this.lastReceived = (byte[])data.clone();
                                this.lastReceived[0] = (byte)(this.lastReceived[0] & 0xFFFFFFDF);
                                this.fireFrameReceived(this.createLDataInd(data));
                            }
                            catch (Exception e) {
                                TpuartConnection.this.logger.error("error creating {} from TP1 data (length {}): {}", new Object[]{TpuartConnection.this.busmon ? "Busmon.ind" : "L-Data", frame.length, DataUnitBuilder.toHex(frame, " "), e});
                                this.in.reset();
                            }
                        }
                        finally {
                            this.in.reset();
                        }
                    }
                }
            } else if (this.isLDataStart(c)) {
                this.lastRead = now;
                this.in.reset();
                this.in.write(c);
                this.frameAcked = false;
                byte[] minBytes = new byte[this.extFrame ? 6 : 5];
                int read = TpuartConnection.this.is.read(minBytes);
                long initialMinBytes = System.nanoTime() / 1000L - this.lastRead;
                if (read > 0) {
                    this.in.write(minBytes, 0, read - 1);
                    this.lastRead = System.nanoTime() / 1000L;
                    this.parseFrame(minBytes[read - 1]);
                }
                TpuartConnection.this.logger.trace("finished reading {} bytes after {} us", (Object)read, (Object)initialMinBytes);
            } else if (c == 204 || c == 12 || c == 192) {
                this.fireFrameReceived(this.createBusmonInd(new byte[]{(byte)c}));
            } else {
                return false;
            }
            return true;
        }

        private void resetReceiveBuffer(int c, long diff) {
            byte[] buf = this.in.toByteArray();
            this.in.reset();
            TpuartConnection.this.logger.debug("reset receive buffer after {} us, char 0x{}, discard partial frame (length {}) {}", new Object[]{diff, Integer.toHexString(c), buf.length, DataUnitBuilder.toHex(buf, " ")});
            ++this.consecutiveFrameDrops;
        }

        private void checkUartState() throws IOException {
            long now = System.nanoTime() / 1000L;
            if (this.lastUartState + 5000000L < now) {
                if (this.lastUartState != 0L && now > this.lastUartState + 10000000L + 100000L) {
                    TpuartConnection.this.close(3, "communication not possible, TP1 medium not connected?");
                } else {
                    this.readUartState();
                }
            }
        }

        private void readUartState() throws IOException {
            if (this.uartStatePending) {
                return;
            }
            this.uartStatePending = true;
            TpuartConnection.this.os.write(2);
        }

        private boolean isUartStateInd(int c) {
            boolean ind;
            if (!this.uartStatePending) {
                return false;
            }
            boolean bl = ind = (c & 7) == 7;
            if (!ind) {
                return false;
            }
            this.uartStatePending = false;
            this.lastUartState = System.nanoTime() / 1000L;
            boolean slaveCollision = (c & 0x80) == 128;
            boolean rxError = (c & 0x40) == 64;
            boolean txError = (c & 0x20) == 32;
            boolean protError = (c & 0x10) == 16;
            boolean tempWarning = (c & 8) == 8;
            boolean info = slaveCollision || rxError || txError || protError || tempWarning;
            LogService.log(TpuartConnection.this.logger, info ? LogService.LogLevel.INFO : LogService.LogLevel.TRACE, "TP-UART status: Temp. {}{}{}{}{}", tempWarning ? "warning" : "OK", slaveCollision ? ", slave collision" : "", rxError ? ", receive error" : "", txError ? ", transmit error" : "", protError ? ", protocol error" : "");
            if (tempWarning) {
                this.coolDownUntil = System.nanoTime() + 1000000000L;
                TpuartConnection.this.logger.warn("TP-UART high temperature warning! Sending is paused for 1 second ...");
            }
            return true;
        }

        private boolean isLDataCon(int c) {
            boolean con;
            boolean bl = con = (c & 0x7F) == 11;
            if (con) {
                boolean pos = (c & 0x80) == 128;
                String status = pos ? "positive" : "negative";
                TpuartConnection.this.logger.debug("{} L_Data.con", (Object)status);
                this.onConfirmation(pos);
            }
            return con;
        }

        private boolean isLDataStart(int c) {
            boolean start;
            if ((c & 3) != 0) {
                return false;
            }
            boolean bl = start = (c & 0xD0) == 144 || (c & 0xD0) == 16;
            if (start) {
                this.extFrame = (c & 0xD0) == 16;
            }
            return start;
        }

        private void ack(byte[] frame) throws IOException {
            boolean oneOfUs;
            boolean groupResponse;
            if (TpuartConnection.this.busmon || this.frameAcked) {
                return;
            }
            int addrOffset = this.extFrame ? 4 : 3;
            byte[] addr = new byte[]{frame[addrOffset], frame[addrOffset + 1]};
            int addrTypeOffset = this.extFrame ? 1 : 5;
            boolean group = (frame[addrTypeOffset] & 0x80) == 128;
            KNXAddress dst = group ? new GroupAddress(addr) : new IndividualAddress(addr);
            int ack = 16;
            long timestamp = TpuartConnection.this.sending.getOrDefault(dst, 0L);
            boolean bl = groupResponse = System.nanoTime() - timestamp < 3000000000L;
            if (timestamp > 0L && !groupResponse) {
                TpuartConnection.this.sending.remove(dst);
            }
            boolean bl2 = oneOfUs = TpuartConnection.this.addresses.contains(dst) || groupResponse;
            if (oneOfUs) {
                TpuartConnection.this.os.write(new byte[]{(byte)(ack |= 1)});
                TpuartConnection.this.logger.trace("write ACK (0x{}) for {}", (Object)Integer.toHexString(ack), (Object)dst);
            }
            this.frameAcked = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onConfirmation(boolean pos) {
            byte[] frame = TpuartConnection.this.req;
            if (frame == null) {
                return;
            }
            frame[0] = 46;
            frame[2] = pos ? (byte)(frame[2] & 0xFE) : (byte)(frame[2] | 1);
            Object object = TpuartConnection.this.lock;
            synchronized (object) {
                TpuartConnection.this.state = 0;
                TpuartConnection.this.lock.notifyAll();
            }
            this.fireFrameReceived(frame);
        }

        private byte[] createLDataInd(byte[] tp1) {
            return this.createLData(41, tp1);
        }

        private byte[] createLData(int mc, byte[] tp1) {
            if (!TpuartConnection.this.isValidChecksum(tp1)) {
                return null;
            }
            boolean std = (tp1[0] & 0x90) == 144;
            byte[] ind = new byte[tp1.length + (std ? 2 : 1)];
            ind[0] = (byte)mc;
            ind[1] = 0;
            if (std) {
                ind[2] = tp1[0];
                ind[3] = (byte)(tp1[5] & 0xF0);
                ind[4] = tp1[1];
                ind[5] = tp1[2];
                ind[6] = tp1[3];
                ind[7] = tp1[4];
                int len = tp1[5] & 0xF;
                ind[8] = (byte)len;
                ind[9] = tp1[6];
                int i = 0;
                while (i < len) {
                    ind[10 + i] = tp1[7 + i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < tp1.length - 1) {
                    ind[2 + i] = tp1[i];
                    ++i;
                }
            }
            return ind;
        }

        private byte[] createBusmonInd(byte[] tp1) {
            int seq = TpuartConnection.this.busmonSequence;
            TpuartConnection.this.busmonSequence = (TpuartConnection.this.busmonSequence + 1) % 8;
            long timestamp = System.nanoTime() / 1000L & 0xFFFFFFFFL;
            return CEMIBusMon.newWithSequenceNumber(seq, timestamp, true, tp1).toByteArray();
        }

        private void fireFrameReceived(byte[] frame) {
            if (frame == null) {
                return;
            }
            TpuartConnection.this.logger.trace("cEMI (length {}): {}", (Object)frame.length, (Object)DataUnitBuilder.toHex(frame, " "));
            try {
                CEMI msg = CEMIFactory.create(frame, 0, frame.length);
                FrameEvent fe = new FrameEvent((Object)this, msg);
                TpuartConnection.this.listeners.fire(l -> l.frameReceived(fe));
            }
            catch (RuntimeException | KNXFormatException e) {
                TpuartConnection.this.logger.error("invalid frame for cEMI: {}", (Object)DataUnitBuilder.toHex(frame, " "), (Object)e);
            }
        }
    }
}

