/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial.usb;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.usb.UsbClaimException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbIrp;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.UsbPlatformException;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeEvent;
import javax.usb.event.UsbPipeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.Context;
import org.usb4java.DescriptorUtils;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.javax.Services;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.serial.ConnectionEvent;
import tuwien.auto.calimero.serial.ConnectionStatus;
import tuwien.auto.calimero.serial.KNXPortClosedException;
import tuwien.auto.calimero.serial.usb.HidReport;
import tuwien.auto.calimero.serial.usb.HidReportHeader;
import tuwien.auto.calimero.serial.usb.TransferProtocolHeader;

public class UsbConnection
implements Connection<HidReport> {
    private static final int[] virtualSerialVendorIds = new int[]{1003};
    private static final int[] virtualSerialProductIds = new int[]{8267};
    private static final int tunnelingTimeout = 1500;
    private static final String logPrefix = "calimero.usb";
    private static final Logger slogger = LoggerFactory.getLogger((String)"calimero.usb");
    private final Logger logger;
    private final String name;
    private static final Map<Integer, List<Integer>> vendorProductIds = UsbConnection.loadKnxUsbVendorProductIds();
    private final EventListeners<KNXListener> listeners;
    private final UsbDevice dev;
    private final UsbInterface knxUsbIf;
    private final UsbPipe out;
    private final UsbPipe in;
    private final Object responseLock = new Object();
    private HidReport response;
    private final List<HidReport> partialReportList = Collections.synchronizedList(new ArrayList());
    private final UsbCallback callback = new UsbCallback();

    static {
        try {
            UsbConnection.printDevices();
        }
        catch (KnxRuntimeException e) {
            slogger.error("Enumerate USB devices, " + e);
        }
        try {
            StringBuilder sb = new StringBuilder();
            List<UsbDevice> devices = UsbConnection.getKnxDevices();
            for (UsbDevice d : devices) {
                try {
                    sb.append("\n").append(UsbConnection.printInfo(d, slogger, " |   "));
                }
                catch (UsbException usbException) {}
            }
            slogger.info("Found {} KNX USB devices{}{}", new Object[]{devices.size(), sb.length() > 0 ? ":" : "", sb});
        }
        catch (RuntimeException runtimeException) {}
    }

    private static Map<Integer, List<Integer>> loadKnxUsbVendorProductIds() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream is = UsbConnection.class.getResourceAsStream("/knxUsbVendorProductIds");){
                Stream<String> lines = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines();
                int[] currentVendor = new int[1];
                return Map.copyOf(lines.filter(s -> !s.startsWith("#") && !s.isBlank()).collect(Collectors.groupingBy(line -> line.startsWith("\t") ? currentVendor[0] : UsbConnection.fromHex(line), Collectors.flatMapping(UsbConnection::productsIds, Collectors.toUnmodifiableList()))));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            slogger.warn("failed loading KNX USB vendor:product IDs, autodetection of USB devices won't work", (Throwable)e);
            return Map.of();
        }
    }

    private static Stream<Integer> productsIds(String line) {
        return line.startsWith("\t") ? List.of(line.split("#")[0].split(",")).stream().map(s -> UsbConnection.fromHex(s)) : Stream.of(new Integer[0]);
    }

    public static void updateDeviceList() throws SecurityException, UsbException {
        ((Services)UsbHostManager.getUsbServices()).scan();
    }

    public static List<UsbDevice> getDevices() {
        return UsbConnection.collect((UsbDevice)UsbConnection.getRootHub());
    }

    public static List<UsbDevice> getKnxDevices() {
        ArrayList<UsbDevice> knx = new ArrayList<UsbDevice>();
        for (UsbDevice d : UsbConnection.getDevices()) {
            UsbDeviceDescriptor descriptor = d.getUsbDeviceDescriptor();
            int vendor = descriptor.idVendor() & 0xFFFF;
            if (!vendorProductIds.getOrDefault(vendor, List.of()).contains(descriptor.idProduct() & 0xFFFF)) continue;
            knx.add(d);
        }
        return knx;
    }

    public static List<UsbDevice> getVirtualSerialKnxDevices() throws SecurityException {
        ArrayList<UsbDevice> knx = new ArrayList<UsbDevice>();
        for (UsbDevice d : UsbConnection.getDevices()) {
            int vendor = d.getUsbDeviceDescriptor().idVendor() & 0xFFFF;
            int product = d.getUsbDeviceDescriptor().idProduct() & 0xFFFF;
            int i = 0;
            while (i < virtualSerialVendorIds.length) {
                int v = virtualSerialVendorIds[i];
                if (v == vendor && virtualSerialProductIds[i] == product) {
                    knx.add(d);
                }
                ++i;
            }
        }
        return knx;
    }

    public static void printDevices() {
        StringBuilder sb = new StringBuilder();
        UsbConnection.traverse((UsbDevice)UsbConnection.getRootHub(), sb, "");
        slogger.debug("Enumerate USB devices\n{}", (Object)sb);
        if (slogger.isDebugEnabled()) {
            slogger.debug("Enumerate USB devices using the low-level API\n{}", (Object)UsbConnection.getDeviceDescriptionsLowLevel().stream().collect(Collectors.joining("\n")));
        }
    }

    public UsbConnection(String device) throws KNXException {
        this(UsbConnection.findDevice(device), device);
    }

    public UsbConnection(int vendorId, int productId) throws KNXException {
        this(UsbConnection.findDevice(vendorId, productId), UsbConnection.toDeviceId(vendorId, productId));
    }

    private UsbConnection(UsbDevice device, String name) throws KNXException {
        this.dev = device;
        this.name = name.isEmpty() ? UsbConnection.toDeviceId(device) : name;
        this.logger = LoggerFactory.getLogger((String)("calimero.usb." + this.name()));
        this.listeners = new EventListeners(this.logger, ConnectionEvent.class);
        this.listeners.registerEventType(ConnectionStatus.class);
        try {
            UsbIrp irp;
            Object[] usbIfInOut = this.open(device);
            this.knxUsbIf = (UsbInterface)usbIfInOut[0];
            int epAddressIn = (Integer)usbIfInOut[1];
            int epAddressOut = (Integer)usbIfInOut[2];
            this.out = UsbConnection.open(this.knxUsbIf, epAddressOut);
            this.in = UsbConnection.open(this.knxUsbIf, epAddressIn);
            this.in.addUsbPipeListener((UsbPipeListener)this.callback);
            do {
                irp = this.in.asyncSubmit(new byte[64]);
                irp.waitUntilComplete(10L);
            } while (irp.isComplete());
            this.callback.start();
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException | UsbNotClaimedException e) {
            throw new KNXException("open USB connection '" + this.name + "'", e);
        }
    }

    private static String toDeviceId(UsbDevice device) {
        UsbDeviceDescriptor dd = device.getUsbDeviceDescriptor();
        return UsbConnection.toDeviceId(dd.idVendor(), dd.idProduct());
    }

    @Override
    public void addConnectionListener(KNXListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeConnectionListener(KNXListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void send(HidReport frame, Connection.BlockingMode blockingMode) throws KNXPortClosedException, KNXTimeoutException {
        this.send(frame, blockingMode != Connection.BlockingMode.NonBlocking);
    }

    public void send(HidReport report, boolean blocking) throws KNXPortClosedException, KNXTimeoutException {
        try {
            byte[] data = report.toByteArray();
            this.logger.trace("sending I/O request {}", (Object)DataUnitBuilder.toHex(Arrays.copyOfRange(data, 0, report.getReportHeader().getDataLength() + 3), ""));
            this.out.syncSubmit(data);
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException | UsbNotClaimedException e) {
            this.close();
            throw new KNXPortClosedException("error sending report over USB", this.name, e);
        }
    }

    public final DeviceDescriptor.DD0 deviceDescriptor() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        return DeviceDescriptor.DD0.from((int)UsbConnection.toUnsigned(this.getFeature(HidReport.BusAccessServerFeature.DeviceDescriptorType0)));
    }

    public final EnumSet<EmiType> getSupportedEmiTypes() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        return EmiType.fromBits(this.getFeature(HidReport.BusAccessServerFeature.SupportedEmiTypes)[1]);
    }

    public final EmiType getActiveEmiType() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        int bits = (int)UsbConnection.toUnsigned(this.getFeature(HidReport.BusAccessServerFeature.ActiveEmiType));
        EnumSet<EmiType> all = EnumSet.allOf(EmiType.class);
        for (EmiType t : all) {
            if (t.emi.id() != bits) continue;
            return t;
        }
        throw new KNXIllegalArgumentException("unspecified EMI type " + bits);
    }

    public final void setActiveEmiType(EmiType active) throws KNXPortClosedException, KNXTimeoutException {
        HidReport r = HidReport.createFeatureService(TransferProtocolHeader.BusAccessServerService.Set, HidReport.BusAccessServerFeature.ActiveEmiType, new byte[]{(byte)active.emi.id()});
        this.send(r, true);
    }

    public final boolean isKnxConnectionActive() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        byte data = this.getFeature(HidReport.BusAccessServerFeature.ConnectionStatus)[0];
        return (data & 1) == 1;
    }

    public final int getManufacturerCode() throws KNXPortClosedException, KNXTimeoutException, InterruptedException {
        return (int)UsbConnection.toUnsigned(this.getFeature(HidReport.BusAccessServerFeature.Manufacturer));
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public void close() {
        this.close(2, "user request");
    }

    private Object[] open(UsbDevice device) throws UsbException {
        this.logger.info(UsbConnection.printInfo(device, this.logger, ""));
        UsbConfiguration configuration = device.getActiveUsbConfiguration();
        List interfaces = configuration.getUsbInterfaces();
        UsbInterface useUsbIf = null;
        int epAddressOut = 0;
        int epAddressIn = 0;
        for (UsbInterface uif : interfaces) {
            List settings = uif.getSettings();
            for (UsbInterface alt : settings) {
                this.logger.trace("Interface {}, setting {}", (Object)alt, (Object)(alt.getUsbInterfaceDescriptor().bAlternateSetting() & 0xFF));
                byte ifClass = alt.getUsbInterfaceDescriptor().bInterfaceClass();
                if (ifClass != 3) {
                    this.logger.warn("{} {} doesn't look right, no HID class", (Object)device, (Object)alt);
                    continue;
                }
                List endpoints = alt.getUsbEndpoints();
                for (UsbEndpoint endpoint : endpoints) {
                    boolean epIn;
                    byte addr = endpoint.getUsbEndpointDescriptor().bEndpointAddress();
                    int index = addr & 0xF;
                    String inout = DescriptorUtils.getDirectionName((byte)addr);
                    this.logger.trace("EP {} {}", (Object)index, (Object)inout);
                    boolean bl = epIn = (addr & 0xFFFFFF80) != 0;
                    if (epIn && epAddressIn == 0) {
                        epAddressIn = addr & 0xFF;
                    }
                    if (!epIn && epAddressOut == 0) {
                        epAddressOut = addr & 0xFF;
                    }
                    if (useUsbIf != null || epAddressIn == 0 || epAddressOut == 0) continue;
                    useUsbIf = alt;
                }
            }
        }
        this.logger.debug("Found USB device endpoint addresses OUT 0x{}, IN 0x{}", (Object)Integer.toHexString(epAddressOut), (Object)Integer.toHexString(epAddressIn));
        UsbInterface usbIf = Optional.ofNullable(useUsbIf).orElse(configuration.getUsbInterface((byte)0));
        try {
            usbIf.claim();
        }
        catch (UsbClaimException | UsbPlatformException throwable) {
            usbIf.claim(forceClaim -> true);
        }
        return new Object[]{usbIf, epAddressIn, epAddressOut};
    }

    private static UsbPipe open(UsbInterface usbIf, int endpointAddress) throws KNXException, UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        UsbEndpoint epout = usbIf.getUsbEndpoint((byte)endpointAddress);
        if (epout == null) {
            throw new KNXException(usbIf.getUsbConfiguration().getUsbDevice() + " contains no KNX USB data endpoint 0x" + Integer.toUnsignedString(endpointAddress, 16));
        }
        UsbPipe pipe = epout.getUsbPipe();
        pipe.open();
        return pipe;
    }

    private void close(int initiator, String reason) {
        block16: {
            if (!this.knxUsbIf.isClaimed()) {
                return;
            }
            boolean win = System.getProperty("os.name", "unknown").toLowerCase().contains("win");
            try {
                try {
                    this.in.removeUsbPipeListener((UsbPipeListener)this.callback);
                    this.callback.quit();
                    if (this.out.isOpen()) {
                        this.out.abortAllSubmissions();
                        this.out.close();
                    }
                    if (this.in.isOpen()) {
                        this.in.abortAllSubmissions();
                        this.in.close();
                    }
                    String ifname = "" + this.knxUsbIf.getUsbInterfaceDescriptor().bInterfaceNumber();
                    try {
                        String s = this.knxUsbIf.getInterfaceString();
                        if (s != null) {
                            ifname = s;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    this.logger.trace("release USB interface {}, active={}, claimed={}", new Object[]{ifname, this.knxUsbIf.isActive(), this.knxUsbIf.isClaimed()});
                    this.knxUsbIf.release();
                }
                catch (UsbDisconnectedException | UsbException | UsbNotActiveException | UsbNotOpenException e) {
                    if (win && e instanceof UsbPlatformException) {
                        this.logger.debug("close connection, {}", (Object)e.getMessage());
                    } else {
                        this.logger.warn("close connection", e);
                    }
                    if (win) {
                        this.removeClaimedInterfaceNumberOnWindows();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (win) {
                    this.removeClaimedInterfaceNumberOnWindows();
                }
                throw throwable;
            }
            if (win) {
                this.removeClaimedInterfaceNumberOnWindows();
            }
        }
        this.listeners.fire(l -> l.connectionClosed(new CloseEvent(this, initiator, reason)));
    }

    private void removeClaimedInterfaceNumberOnWindows() {
        try {
            Class<?> c = this.dev.getClass();
            Class<?> abstractDevice = c.getSuperclass();
            Field field = abstractDevice.getDeclaredField("claimedInterfaceNumbers");
            field.setAccessible(true);
            Object set = field.get(this.dev);
            if (set instanceof Set) {
                Set numbers = (Set)set;
                numbers.remove(this.knxUsbIf.getUsbInterfaceDescriptor().bInterfaceNumber());
            }
        }
        catch (Exception e) {
            this.logger.error("on removing claimed interface number, subsequent claims might fail!", (Throwable)e);
        }
    }

    private byte[] getFeature(HidReport.BusAccessServerFeature feature) throws InterruptedException, KNXPortClosedException, KNXTimeoutException {
        HidReport r = HidReport.createFeatureService(TransferProtocolHeader.BusAccessServerService.Get, feature, new byte[0]);
        this.send(r, true);
        HidReport res = this.waitForResponse();
        return res.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HidReport waitForResponse() throws InterruptedException, KNXTimeoutException {
        long remaining = 1500L;
        long end = System.currentTimeMillis() + remaining;
        while (remaining > 0L) {
            Object object = this.responseLock;
            synchronized (object) {
                if (this.response != null) {
                    HidReport r = this.response;
                    this.response = null;
                    return r;
                }
                this.responseLock.wait(remaining);
            }
            remaining = end - System.currentTimeMillis();
        }
        throw new KNXTimeoutException("waiting for response");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(HidReport response) {
        Object object = this.responseLock;
        synchronized (object) {
            this.response = response;
            this.responseLock.notify();
        }
    }

    private void assemblePartialPackets(HidReport part) throws KNXFormatException {
        this.partialReportList.add(part);
        if (!part.getReportHeader().getPacketType().contains((Object)HidReportHeader.PacketType.End)) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TransferProtocolHeader.KnxTunnelEmi emiType = null;
        int i = 0;
        while (i < this.partialReportList.size()) {
            HidReport r = this.partialReportList.get(i);
            if (r.getReportHeader().getSeqNumber() != i + 1) {
                String reports = this.partialReportList.stream().map(Object::toString).collect(Collectors.joining("]\n\t[", "\t[", "]"));
                this.logger.warn("received out of order HID report (expected seq {}, got {}) - ignore complete KNX frame, discard reports:\n{}", new Object[]{i + 1, r.getReportHeader().getSeqNumber(), reports});
                this.partialReportList.clear();
                return;
            }
            if (r.getReportHeader().getPacketType().contains((Object)HidReportHeader.PacketType.Start)) {
                emiType = (TransferProtocolHeader.KnxTunnelEmi)r.getTransferProtocolHeader().getService();
            }
            byte[] body = r.getData();
            data.write(body, 0, body.length);
            ++i;
        }
        byte[] assembled = data.toByteArray();
        this.logger.debug("assembling KNX data frame from {} partial packets complete: {}", (Object)this.partialReportList.size(), (Object)DataUnitBuilder.toHex(assembled, " "));
        this.partialReportList.clear();
        this.fireFrameReceived(emiType, assembled);
    }

    private void fireFrameReceived(TransferProtocolHeader.KnxTunnelEmi emiType, byte[] frame) throws KNXFormatException {
        this.logger.debug("received {} frame {}", (Object)emiType, (Object)DataUnitBuilder.toHex(frame, ""));
        FrameEvent fe = (frame[0] & 0xFF) == 240 ? new FrameEvent((Object)this, frame) : (emiType == TransferProtocolHeader.KnxTunnelEmi.CEmi ? new FrameEvent((Object)this, CEMIFactory.create(frame, 0, frame.length)) : new FrameEvent((Object)this, frame));
        this.listeners.fire(l -> l.frameReceived(fe));
    }

    private static UsbHub getRootHub() {
        try {
            return UsbHostManager.getUsbServices().getRootUsbHub();
        }
        catch (SecurityException | UsbException e) {
            throw new KnxRuntimeException("Accessing USB root hub", e);
        }
    }

    private static List<UsbDevice> getAttachedDevices(UsbHub hub) {
        return hub.getAttachedUsbDevices();
    }

    private static UsbDevice findDevice(int vendorId, int productId) throws KNXException {
        return UsbConnection.findDevice(UsbConnection.getRootHub(), vendorId, productId);
    }

    private static UsbDevice findDevice(UsbHub hub, int vendorId, int productId) throws KNXException {
        for (UsbDevice d : UsbConnection.getAttachedDevices(hub)) {
            UsbDeviceDescriptor dd = d.getUsbDeviceDescriptor();
            if ((dd.idVendor() & 0xFFFF) == vendorId && (dd.idProduct() & 0xFFFF) == productId) {
                return d;
            }
            if (!d.isUsbHub()) continue;
            try {
                return UsbConnection.findDevice((UsbHub)d, vendorId, productId);
            }
            catch (KNXException kNXException) {}
        }
        throw new KNXException(String.valueOf(UsbConnection.toDeviceId(vendorId, productId)) + " not found");
    }

    private static UsbDevice findDevice(String device) throws KNXException {
        try {
            String[] split = device.split(":", -1);
            if (split.length == 2) {
                try {
                    int vendorId = UsbConnection.fromHex(split[0]);
                    int productId = UsbConnection.fromHex(split[1]);
                    return UsbConnection.findDevice(UsbConnection.getRootHub(), vendorId, productId);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return UsbConnection.findDeviceByNameLowLevel(device);
        }
        catch (SecurityException | UsbDisconnectedException e) {
            throw new KNXException("find USB device matching '" + device + "'", e);
        }
    }

    private static List<UsbDevice> collect(UsbDevice device) {
        ArrayList<UsbDevice> l = new ArrayList<UsbDevice>();
        if (device.isUsbHub()) {
            UsbConnection.getAttachedDevices((UsbHub)device).forEach(d -> {
                boolean bl = l.addAll(UsbConnection.collect(d));
            });
        } else {
            l.add(device);
        }
        return l;
    }

    private static void traverse(UsbDevice device, StringBuilder sb, String indent) {
        try {
            sb.append(UsbConnection.printInfo(device, slogger, indent));
        }
        catch (UsbException e) {
            slogger.warn("Accessing USB device, " + (Object)((Object)e));
        }
        if (device.isUsbHub()) {
            Iterator<UsbDevice> i = UsbConnection.getAttachedDevices((UsbHub)device).iterator();
            while (i.hasNext()) {
                UsbConnection.traverse(i.next(), sb.append("\n"), String.valueOf(indent) + (i.hasNext() ? " |   " : "     "));
            }
        }
    }

    private static String printInfo(UsbDevice device, Logger l, String indent) throws UsbException {
        boolean virtual;
        StringBuilder sb = new StringBuilder();
        UsbDeviceDescriptor dd = device.getUsbDeviceDescriptor();
        String s = indent.isEmpty() ? "" : String.valueOf(indent.substring(0, indent.length() - 5)) + " |--";
        sb.append(s).append(device.toString());
        boolean bl = virtual = device instanceof UsbHub && ((UsbHub)device).isRootUsbHub();
        if (virtual) {
            return sb.toString();
        }
        byte manufacturer = dd.iManufacturer();
        byte product = dd.iProduct();
        byte sno = dd.iSerialNumber();
        try {
            String desc = indent;
            if (product != 0) {
                desc = String.valueOf(desc) + UsbConnection.trimAtNull(device.getString(product));
            }
            if (manufacturer != 0) {
                desc = String.valueOf(desc) + " (" + UsbConnection.trimAtNull(device.getString(manufacturer)) + ")";
            }
            if (!desc.equals(indent)) {
                sb.append("\n").append(desc);
            }
            if (sno != 0) {
                sb.append("\n").append(indent).append("S/N ").append(device.getString(sno));
            }
        }
        catch (UnsupportedEncodingException e) {
            l.error("Java platform lacks support for the required standard charset UTF-16LE", (Throwable)e);
        }
        catch (UsbPlatformException e) {
            l.debug("extracting USB device strings, {}", (Object)e.toString());
        }
        return sb.toString();
    }

    private static String trimAtNull(String s) {
        int end = s.indexOf(0);
        return end > -1 ? s.substring(0, end) : s;
    }

    private static boolean isKnxInterfaceId(String device) {
        String[] split = device.split(":", -1);
        try {
            int vend = UsbConnection.fromHex(split[0]);
            int prod = UsbConnection.fromHex(split[1]);
            return vendorProductIds.getOrDefault(vend, List.of()).contains(prod);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static UsbDevice findDeviceByNameLowLevel(String name) throws KNXException {
        List<String> list = UsbConnection.getDeviceDescriptionsLowLevel();
        if (name.isEmpty()) {
            list.removeIf(i -> !UsbConnection.isKnxInterfaceId(i.split("ID |\n")[1]));
        } else {
            list.removeIf(i -> i.toLowerCase().indexOf(name.toLowerCase()) == -1);
        }
        if (list.isEmpty()) {
            throw new KNXException("no KNX USB device found" + (name.isEmpty() ? "" : " with name matching '" + name + "'"));
        }
        String desc = list.get(0);
        String id = desc.substring(desc.indexOf("ID") + 3, desc.indexOf("\n"));
        return UsbConnection.findDevice(id);
    }

    private static List<String> getDeviceDescriptionsLowLevel() {
        Context ctx = new Context();
        int err = LibUsb.init((Context)ctx);
        if (err != 0) {
            slogger.error("LibUsb initialization error {}: {}", (Object)(-err), (Object)LibUsb.strError((int)err));
            return Collections.emptyList();
        }
        try {
            List<String> list;
            DeviceList list2 = new DeviceList();
            int res = LibUsb.getDeviceList((Context)ctx, (DeviceList)list2);
            if (res < 0) {
                slogger.error("LibUsb device list error {}: {}", (Object)(-res), (Object)LibUsb.strError((int)res));
                List<String> list3 = Collections.emptyList();
                return list3;
            }
            try {
                list = StreamSupport.stream(list2.spliterator(), false).map(UsbConnection::printInfo).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                LibUsb.freeDeviceList((DeviceList)list2, (boolean)true);
                throw throwable;
            }
            LibUsb.freeDeviceList((DeviceList)list2, (boolean)true);
            return list;
        }
        finally {
            LibUsb.exit((Context)ctx);
        }
    }

    private static String printInfo(Device device) {
        int speed;
        ByteBuffer path;
        int result;
        int port;
        int bus = LibUsb.getBusNumber((Device)device);
        int address = LibUsb.getDeviceAddress((Device)device);
        int vendor = 0;
        int product = 0;
        DeviceDescriptor d = new DeviceDescriptor();
        int err = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)d);
        if (err == 0) {
            vendor = d.idVendor() & 0xFFFF;
            product = d.idProduct() & 0xFFFF;
        }
        StringBuilder sb = new StringBuilder();
        String item = vendor != 0 ? UsbConnection.toDeviceId(vendor, product) : "";
        sb.append("Bus ").append(bus).append(" Device ").append(address).append(": ID ").append(item);
        DeviceHandle dh = new DeviceHandle();
        err = LibUsb.open((Device)device, (DeviceHandle)dh);
        if (err == 0) {
            try {
                String man = LibUsb.getStringDescriptor((DeviceHandle)dh, (byte)d.iManufacturer());
                String prodname = LibUsb.getStringDescriptor((DeviceHandle)dh, (byte)d.iProduct());
                String desc = "    ";
                if (prodname != null) {
                    desc = String.valueOf(desc) + prodname;
                }
                if (man != null) {
                    desc = String.valueOf(desc) + " (" + man + ")";
                }
                if (!desc.equals("    ")) {
                    sb.append("\n").append(desc);
                }
            }
            finally {
                LibUsb.close((DeviceHandle)dh);
            }
        }
        String attach = "";
        Device parent = LibUsb.getParent((Device)device);
        if (parent != null) {
            int parentBus = LibUsb.getBusNumber((Device)parent);
            int parentAddress = LibUsb.getDeviceAddress((Device)parent);
            attach = "Parent Hub " + parentBus + ":" + parentAddress;
        }
        if ((port = LibUsb.getPortNumber((Device)device)) != 0) {
            attach = String.valueOf(attach) + (attach.isEmpty() ? "Attached at port " : ", attached at port ") + port;
        }
        if ((result = LibUsb.getPortNumbers((Device)device, (ByteBuffer)(path = ByteBuffer.allocateDirect(8)))) > 0) {
            attach = String.valueOf(attach) + IntStream.range(0, result).map(path::get).mapToObj(Integer::toString).collect(Collectors.joining("/", " (/bus:" + LibUsb.getBusNumber((Device)device) + "/", ")"));
        }
        if (!attach.isEmpty()) {
            sb.append("\n").append("    ").append(attach);
        }
        if ((speed = LibUsb.getDeviceSpeed((Device)device)) != 0) {
            sb.append("\n").append("    ").append(DescriptorUtils.getSpeedName((int)speed)).append(" Speed USB");
        }
        return sb.toString();
    }

    public static Device findDeviceLowLevel(int vendorId, int productId) {
        Context ctx = null;
        int err = LibUsb.init(null);
        if (err != 0) {
            slogger.error("LibUsb initialization error {}: {}", (Object)(-err), (Object)LibUsb.strError((int)err));
            return null;
        }
        DeviceList list = new DeviceList();
        int res = LibUsb.getDeviceList(ctx, (DeviceList)list);
        if (res < 0) {
            slogger.error("LibUsb device list error {}: {}", (Object)(-res), (Object)LibUsb.strError((int)res));
            return null;
        }
        try {
            for (Device device : list) {
                DeviceDescriptor d;
                err = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)(d = new DeviceDescriptor()));
                if (err != 0) continue;
                int vendor = d.idVendor() & 0xFFFF;
                int product = d.idProduct() & 0xFFFF;
                if (vendor != vendorId || product != productId) continue;
                LibUsb.refDevice((Device)device);
                Device device2 = device;
                return device2;
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        return null;
    }

    public static Optional<String> getProductName(Device device) {
        DeviceDescriptor d = new DeviceDescriptor();
        DeviceHandle dh = new DeviceHandle();
        if (LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)d) == 0 && LibUsb.open((Device)device, (DeviceHandle)dh) == 0) {
            try {
                Optional<String> optional = Optional.ofNullable(LibUsb.getStringDescriptor((DeviceHandle)dh, (byte)d.iProduct()));
                return optional;
            }
            finally {
                LibUsb.close((DeviceHandle)dh);
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getManufacturer(Device device) {
        DeviceDescriptor d = new DeviceDescriptor();
        DeviceHandle dh = new DeviceHandle();
        if (LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)d) == 0 && LibUsb.open((Device)device, (DeviceHandle)dh) == 0) {
            try {
                Optional<String> optional = Optional.ofNullable(LibUsb.getStringDescriptor((DeviceHandle)dh, (byte)d.iManufacturer()));
                return optional;
            }
            finally {
                LibUsb.close((DeviceHandle)dh);
            }
        }
        return Optional.empty();
    }

    private static String toDeviceId(int vendorId, int productId) {
        return String.format("%04x:%04x", vendorId, productId);
    }

    private static long toUnsigned(byte[] data) {
        if (data.length == 1) {
            return data[0] & 0xFF;
        }
        if (data.length == 2) {
            return (long)(data[0] & 0xFF) << 8 | (long)(data[1] & 0xFF);
        }
        return (long)(data[0] & 0xFF) << 24 | (long)((data[1] & 0xFF) << 16) | (long)((data[2] & 0xFF) << 8) | (long)(data[3] & 0xFF);
    }

    private static int fromHex(String hex) {
        return Integer.valueOf(hex.strip(), 16);
    }

    public static enum EmiType {
        Emi1(1, TransferProtocolHeader.KnxTunnelEmi.Emi1),
        Emi2(2, TransferProtocolHeader.KnxTunnelEmi.Emi2),
        CEmi(4, TransferProtocolHeader.KnxTunnelEmi.CEmi);

        final int bit;
        public final TransferProtocolHeader.KnxTunnelEmi emi;

        static EnumSet<EmiType> fromBits(int bitfield) {
            EnumSet<EmiType> types = EnumSet.noneOf(EmiType.class);
            EmiType[] emiTypeArray = EmiType.values();
            int n = emiTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EmiType t = emiTypeArray[n2];
                if ((bitfield & t.bit) == t.bit) {
                    types.add(t);
                }
                ++n2;
            }
            return types;
        }

        private EmiType(int bit, TransferProtocolHeader.KnxTunnelEmi emi) {
            this.bit = bit;
            this.emi = emi;
        }
    }

    private final class UsbCallback
    extends Thread
    implements UsbPipeListener {
        private volatile boolean close;

        private UsbCallback() {
            this.setDaemon(true);
            this.setName("Calimero USB callback");
        }

        @Override
        public void run() {
            block3: {
                try {
                    while (!this.close) {
                        UsbConnection.this.in.syncSubmit(new byte[64]);
                    }
                }
                catch (IllegalArgumentException | UsbDisconnectedException | UsbException | UsbNotActiveException | UsbNotOpenException e) {
                    if (this.close) break block3;
                    UsbConnection.this.close(3, e.getMessage());
                }
            }
        }

        public void errorEventOccurred(UsbPipeErrorEvent event) {
            byte epaddr = this.endpointAddress((UsbPipeEvent)event);
            int idx = epaddr & 0xF;
            String dir = DescriptorUtils.getDirectionName((byte)epaddr);
            UsbException e = event.getUsbException();
            UsbConnection.this.logger.error("EP {} {} error event for I/O request, {}", new Object[]{idx, dir, e.toString()});
        }

        public void dataEventOccurred(UsbPipeDataEvent event) {
            byte epaddr = this.endpointAddress((UsbPipeEvent)event);
            int idx = epaddr & 0xF;
            String dir = DescriptorUtils.getDirectionName((byte)epaddr);
            byte[] data = event.getData();
            if (event.getActualLength() == 0 || Arrays.equals(data, new byte[64])) {
                UsbConnection.this.logger.debug("EP {} {} empty I/O request (length {})", new Object[]{idx, dir, event.getActualLength()});
                return;
            }
            try {
                HidReport r = new HidReport(data);
                UsbConnection.this.logger.trace("EP {} {} I/O request {}", new Object[]{idx, dir, DataUnitBuilder.toHex(Arrays.copyOfRange(data, 0, r.getReportHeader().getDataLength() + 3), "")});
                EnumSet<HidReportHeader.PacketType> packetType = r.getReportHeader().getPacketType();
                TransferProtocolHeader tph = r.getTransferProtocolHeader();
                if (packetType.contains((Object)HidReportHeader.PacketType.Partial) || tph == null) {
                    UsbConnection.this.assemblePartialPackets(r);
                } else if (tph.getProtocol() == TransferProtocolHeader.Protocol.KnxTunnel) {
                    UsbConnection.this.fireFrameReceived((TransferProtocolHeader.KnxTunnelEmi)tph.getService(), r.getData());
                } else if (tph.getProtocol() == TransferProtocolHeader.Protocol.BusAccessServerFeature) {
                    if (tph.getService() == TransferProtocolHeader.BusAccessServerService.Response) {
                        UsbConnection.this.setResponse(r);
                    } else if (tph.getService() == TransferProtocolHeader.BusAccessServerService.Info) {
                        HidReport.BusAccessServerFeature feature = r.getFeatureId();
                        UsbConnection.this.logger.trace("{} {}", (Object)feature, (Object)DataUnitBuilder.toHex(r.getData(), ""));
                    }
                    if (r.getFeatureId() == HidReport.BusAccessServerFeature.ConnectionStatus) {
                        byte status = r.getData()[0];
                        UsbConnection.this.listeners.dispatchCustomEvent((Object)(status == 1 ? ConnectionStatus.Online : ConnectionStatus.Offline));
                    }
                } else {
                    UsbConnection.this.logger.warn("unexpected service {}: {}", (Object)tph.getService(), (Object)DataUnitBuilder.toHex(data, ""));
                }
            }
            catch (RuntimeException | KNXFormatException e) {
                UsbConnection.this.logger.error("creating HID class report from {}", (Object)DataUnitBuilder.toHex(data, ""), (Object)e);
            }
        }

        private byte endpointAddress(UsbPipeEvent event) {
            UsbEndpoint ep = event.getUsbPipe().getUsbEndpoint();
            return ep.getUsbEndpointDescriptor().bEndpointAddress();
        }

        void quit() {
            this.close = true;
        }
    }
}

