/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.References;
import tuwien.auto.calimero.xml.XmlWriter;

public class DefaultXmlWriter
implements XmlWriter {
    private static final int indentWidth = 4;
    private static final String quote = "\"";
    private static final String lt = "<";
    private static final String gt = ">";
    private static final String equal = "=";
    private static final String slash = "/";
    private static final String space = " ";
    private final Map<String, Object> config = new HashMap<String, Object>();
    private final BufferedWriter w;
    private final boolean close;
    private final Stack<Tag> layout;
    private int indent;
    private boolean newTag;
    private boolean empty;

    DefaultXmlWriter(Writer w, boolean closeWriter) {
        this.w = new BufferedWriter(w);
        this.close = closeWriter;
        this.layout = new Stack();
        this.indent = 0;
        this.newTag = false;
    }

    private void writeDeclaration(boolean standalone, String encoding, String version) throws KNXMLException {
        this.write("<?xml version=", quote, version, quote);
        this.write(" standalone=", quote, standalone ? "yes" : "no", quote);
        if (encoding != null && encoding.length() > 0) {
            this.write(" encoding=", quote, encoding, quote);
        }
        this.write("?>");
        try {
            this.w.newLine();
        }
        catch (IOException e) {
            throw new KNXMLException(e.getMessage());
        }
    }

    @Override
    public void writeComment(String comment) throws KNXMLException {
        this.closeStartElement();
        try {
            if (this.newTag) {
                this.w.newLine();
            }
            this.indent();
            this.write("<!--", comment, "-->");
            if (!this.newTag) {
                this.w.newLine();
            }
        }
        catch (IOException e) {
            throw new KNXMLException(e.getMessage(), e);
        }
        this.newTag = false;
    }

    @Override
    public void close() throws KNXMLException {
        this.writeEndDocument();
        try {
            if (this.close) {
                this.w.close();
            }
        }
        catch (IOException iOException) {}
    }

    private BufferedWriter indent() throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.w.write(32);
            ++i;
        }
        return this.w;
    }

    @Override
    public void writeStartElement(String localName) {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        this.writeStartElement(null, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        this.closeStartElement();
        try {
            if (this.newTag) {
                this.w.newLine();
            }
            this.indent();
        }
        catch (IOException e) {
            throw new KNXMLException("write start element", e);
        }
        this.write(lt);
        if (prefix != null) {
            this.write(prefix, ":");
        }
        this.write(localName);
        this.newTag = true;
        this.empty = false;
        this.layout.push(new Tag(localName));
    }

    private void closeStartElement() {
        if (this.empty) {
            this.layout.pop().endTag();
        }
        if (this.newTag) {
            this.write(gt);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        this.writeEmptyElement(null, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.empty = true;
    }

    @Override
    public void writeEmptyElement(String localName) {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeEndElement() {
        this.closeStartElement();
        if (this.layout.empty()) {
            throw new IllegalStateException("no elements to end");
        }
        try {
            this.layout.pop().endTag();
            if (this.layout.empty()) {
                this.w.flush();
            }
        }
        catch (IOException e) {
            throw new KNXMLException(e.getMessage());
        }
    }

    @Override
    public void writeEndDocument() {
        try {
            while (!this.layout.empty()) {
                this.layout.pop().endTag();
            }
            this.w.flush();
        }
        catch (IOException e) {
            throw new KNXMLException(e.getMessage());
        }
    }

    @Override
    public void flush() {
        try {
            this.w.flush();
        }
        catch (IOException e) {
            throw new KNXMLException("close", e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        this.layout.peek().addAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
    }

    @Override
    public void writeProcessingInstruction(String target) {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
    }

    @Override
    public void writeCData(String data) {
        this.write("<![CDATA[", data, "]]>");
    }

    @Override
    public void writeDTD(String dtd) {
    }

    @Override
    public void writeEntityRef(String name) {
    }

    @Override
    public void writeStartDocument() {
        this.writeDeclaration(true, "utf-8", "1.0");
    }

    @Override
    public void writeStartDocument(String version) {
        this.writeDeclaration(true, "utf-8", version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.writeDeclaration(true, encoding, version);
    }

    @Override
    public void writeCharacters(String text) {
        this.closeStartElement();
        this.write(References.replace(text, true));
        this.newTag = false;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        String s = new String(Arrays.copyOfRange(text, start, start + len));
        this.writeCharacters(s);
    }

    @Override
    public String getPrefix(String uri) {
        return (String)this.config.get("prefix");
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.config.put("prefix", uri);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.config.put("namespace", uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.config.get(name);
    }

    private void write(String ... items) {
        try {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null) {
                    this.w.write(s);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new KNXMLException("write", e);
        }
    }

    private final class Tag {
        private final String name;

        Tag(String localName) {
            this.name = localName;
        }

        void addAttribute(String localName, String value) {
            DefaultXmlWriter.this.write(DefaultXmlWriter.space, localName, DefaultXmlWriter.equal, DefaultXmlWriter.quote, References.replace(value, true), DefaultXmlWriter.quote);
        }

        void endTag() {
            try {
                if (this.name != null) {
                    DefaultXmlWriter.this.indent -= 4;
                    if (!DefaultXmlWriter.this.newTag) {
                        DefaultXmlWriter.this.indent();
                    }
                    DefaultXmlWriter.this.newTag = false;
                    if (DefaultXmlWriter.this.empty) {
                        DefaultXmlWriter.this.write(DefaultXmlWriter.space, DefaultXmlWriter.slash, DefaultXmlWriter.gt);
                    } else {
                        DefaultXmlWriter.this.w.write("</" + this.name + DefaultXmlWriter.gt);
                    }
                    DefaultXmlWriter.this.w.newLine();
                    DefaultXmlWriter.this.empty = false;
                }
            }
            catch (IOException e) {
                throw new KNXMLException("endTag", e);
            }
        }
    }
}

