/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.xml.DefaultXmlReader;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlResolver;
import tuwien.auto.calimero.xml.XmlStreamReaderProxy;

public final class XmlInputFactory {
    private static final Logger l = LoggerFactory.getLogger((String)"calimero.xml");
    private final Map<String, Object> config = new HashMap<String, Object>();
    private static final String RESOLVER = "javax.xml.stream.resolver";

    private XmlInputFactory() {
    }

    public static XmlInputFactory newInstance() {
        return new XmlInputFactory();
    }

    public XmlReader createXMLReader(String baseUri) throws KNXMLException {
        XmlResolver res = new XmlResolver();
        InputStream is = (InputStream)res.resolveEntity(null, null, baseUri, null);
        return XmlInputFactory.create(res, is);
    }

    private static XmlReader create(XmlResolver resolver, InputStream is) {
        try {
            XmlStreamReaderProxy r = XmlStreamReaderProxy.createXmlReader(is, is);
            l.trace("using StaX XMLStreamReader {}", (Object)r.r.getClass().getName());
            return r;
        }
        catch (Error | Exception e) {
            l.trace("no StaX implementation found ({}), using internal XMLStreamReader", (Object)e.toString());
            return new DefaultXmlReader(resolver.getInputReader(is), true);
        }
    }

    public XmlReader createXMLStreamReader(Reader reader) {
        try {
            XmlStreamReaderProxy r = XmlStreamReaderProxy.createXmlReader(reader);
            l.trace("using StaX XMLStreamReader {}", (Object)r.r.getClass().getName());
            return r;
        }
        catch (Error | Exception e) {
            l.trace("no StaX implementation found ({}), using internal XMLStreamReader", (Object)e.toString());
            return new DefaultXmlReader(reader, false);
        }
    }

    public XmlReader createXMLStreamReader(InputStream stream) {
        return this.createXMLStreamReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
    }

    public XmlReader createXMLStreamReader(InputStream stream, String encoding) {
        try {
            return this.createXMLStreamReader(new InputStreamReader(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new KNXMLException("XML stream reader with encoding " + encoding, e);
        }
    }

    public XmlReader createXMLStreamReader(String systemId, InputStream stream) {
        return this.createXMLStreamReader(stream);
    }

    public XmlReader createXMLStreamReader(String systemId, Reader reader) {
        return this.createXMLStreamReader(reader);
    }

    public XmlResolver getXMLResolver() {
        return (XmlResolver)this.config.get(RESOLVER);
    }

    public void setXMLResolver(XmlResolver resolver) {
        this.config.put(RESOLVER, resolver);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        this.config.put(name, value);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.config.get(name);
    }

    public boolean isPropertySupported(String name) {
        return this.config.containsKey(name) && this.config.get(name).equals(Boolean.TRUE);
    }
}

