/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.xml.DefaultXmlWriter;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlResolver;
import tuwien.auto.calimero.xml.XmlStreamWriterProxy;
import tuwien.auto.calimero.xml.XmlWriter;

public class XmlOutputFactory {
    private static final Logger l = LoggerFactory.getLogger((String)"calimero.xml");
    private final Map<String, Object> config = new HashMap<String, Object>();

    public static XmlOutputFactory newInstance() {
        return new XmlOutputFactory();
    }

    public XmlWriter createXMLWriter(String systemId) throws KNXMLException {
        XmlResolver res = new XmlResolver();
        OutputStream os = res.resolveOutput(systemId);
        return XmlOutputFactory.create(os, true);
    }

    public XmlWriter createXMLStreamWriter(Writer stream) {
        try {
            XmlStreamWriterProxy w = XmlStreamWriterProxy.createXmlStreamWriter(stream);
            l.trace("using StaX XMLStreamWriter {}", (Object)w.w.getClass().getName());
            return w;
        }
        catch (Error | Exception e) {
            l.trace("no StaX implementation found ({}), using internal XMLStreamWriter", (Object)e.toString());
            return new DefaultXmlWriter(stream, false);
        }
    }

    public XmlWriter createXMLStreamWriter(OutputStream stream) {
        return XmlOutputFactory.create(stream, false);
    }

    private static XmlWriter create(OutputStream stream, boolean closeStream) {
        try {
            XmlStreamWriterProxy w = XmlStreamWriterProxy.createXmlStreamWriter(stream, closeStream ? stream : () -> {});
            l.trace("using StaX XMLStreamWriter {}", (Object)w.w.getClass().getName());
            return w;
        }
        catch (Error | Exception e) {
            l.trace("no StaX implementation found ({}), using internal XMLStreamWriter", (Object)e.toString());
            try {
                return new DefaultXmlWriter(new OutputStreamWriter(stream, "UTF-8"), closeStream);
            }
            catch (UnsupportedEncodingException e2) {
                throw new KNXMLException("encoding UTF-8 unknown", e2);
            }
        }
    }

    public XmlWriter createXMLStreamWriter(OutputStream stream, String encoding) {
        try {
            return this.createXMLStreamWriter(new OutputStreamWriter(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new KNXMLException("encoding", e);
        }
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        this.config.put(name, value);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.config.get(name);
    }

    public boolean isPropertySupported(String name) {
        return this.config.containsKey(name) && this.config.get(name).equals(Boolean.TRUE);
    }
}

