/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.xml.KNXMLException;

public final class XmlResolver {
    private static final Map<String, String> javaNames = new HashMap<String, String>();

    static {
        javaNames.put("LATIN1", "ISO-8859-1");
        javaNames.put("ISO-10646-UCS-2", "UTF-16");
        javaNames.put("EBCDIC-CP-US", "CP037");
        javaNames.put("EBCDIC-CP-CA", "CP037");
        javaNames.put("EBCDIC-CP-NL", "CP037");
        javaNames.put("EBCDIC-CP-WT", "CP037");
    }

    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) {
        try {
            try {
                LoggerFactory.getLogger((String)"calimero.xml").trace("resolve {}", (Object)baseURI);
                URL loc = new URL(baseURI);
                return loc.openConnection().getInputStream();
            }
            catch (MalformedURLException malformedURLException) {
                return new FileInputStream(baseURI);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("error opening " + baseURI, e);
        }
    }

    OutputStream resolveOutput(String systemID) {
        try {
            try {
                URL loc = new URL(systemID);
                if ("file".equals(loc.getProtocol())) {
                    return new FileOutputStream(loc.getPath());
                }
                return loc.openConnection().getOutputStream();
            }
            catch (MalformedURLException malformedURLException) {
                return new FileOutputStream(systemID);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("error opening " + systemID, e);
        }
    }

    Reader getInputReader(InputStream is) throws KNXMLException {
        BufferedInputStream in = null;
        try {
            String ianaEncoding;
            in = new BufferedInputStream(is);
            ((InputStream)in).mark(9000);
            byte[] start = new byte[4];
            int count = ((InputStream)in).read(start);
            ((InputStream)in).reset();
            String encoding = XmlResolver.getEncodingName(in, start, count);
            ((InputStream)in).mark(9000);
            InputStreamReader r = new InputStreamReader((InputStream)in, encoding);
            char[] decl = new char[5];
            r.read(decl);
            if (!new String(decl).equals("<?xml")) {
                ((InputStream)in).reset();
                return new InputStreamReader((InputStream)in, encoding);
            }
            String[] att = XmlResolver.readXMLDeclaration(r);
            ((InputStream)in).reset();
            String javaEncoding = encoding;
            if (att[1] != null && (javaEncoding = javaNames.get(ianaEncoding = att[1].toUpperCase(Locale.ENGLISH))) == null) {
                javaEncoding = ianaEncoding;
            }
            return new InputStreamReader((InputStream)in, javaEncoding);
        }
        catch (IOException e) {
            throw new KNXMLException(e.getMessage());
        }
    }

    private static String getEncodingName(InputStream is, byte[] start, int count) {
        int b0 = start[0] & 0xFF;
        int b1 = start[1] & 0xFF;
        int b2 = start[2] & 0xFF;
        if (count > 1) {
            if (b0 == 254 && b1 == 255) {
                return "UTF-16BE";
            }
            if (b0 == 255 && b1 == 254) {
                return "UTF-16LE";
            }
        }
        if (count >= 3 && b0 == 239 && b1 == 187 && b2 == 191) {
            try {
                is.skip(3L);
            }
            catch (IOException iOException) {}
            return "UTF-8";
        }
        if (count == 4) {
            byte[][] byArrayArray = new byte[5][];
            byte[] byArray = new byte[4];
            byArray[3] = 60;
            byArrayArray[0] = byArray;
            byte[] byArray2 = new byte[4];
            byArray2[0] = 60;
            byArrayArray[1] = byArray2;
            byte[] byArray3 = new byte[4];
            byArray3[1] = 60;
            byArray3[3] = 63;
            byArrayArray[2] = byArray3;
            byte[] byArray4 = new byte[4];
            byArray4[0] = 60;
            byArray4[2] = 63;
            byArrayArray[3] = byArray4;
            byArrayArray[4] = new byte[]{76, 111, -89, -108};
            byte[][] arrays = byArrayArray;
            String[] encodings = new String[]{"ISO-10646-UCS-4", "ISO-10646-UCS-4", "UTF-16BE", "UTF-16LE", "CP037"};
            int i = 0;
            while (i < encodings.length) {
                if (Arrays.equals(arrays[i], start)) {
                    return encodings[i];
                }
                ++i;
            }
        }
        return "UTF-8";
    }

    private static String[] readXMLDeclaration(Reader r) throws KNXMLException {
        StringBuilder buf = new StringBuilder(100);
        try {
            int c = r.read();
            while (c != -1 && c != 63) {
                buf.append((char)c);
                c = r.read();
            }
        }
        catch (IOException e) {
            throw new KNXMLException("reading XML declaration, " + e.getMessage(), buf.toString(), 0);
        }
        String s = buf.toString().trim();
        String version = null;
        String encoding = null;
        String standalone = null;
        int state = 0;
        while (state < 3) {
            if (state == 0 && s.startsWith("version")) {
                s = s.substring(7);
                version = XmlResolver.getAttValue(s);
                s = s.substring(s.indexOf(version) + version.length() + 1).trim();
            } else if (state == 1 && s.startsWith("encoding")) {
                s = s.substring(8);
                encoding = XmlResolver.getAttValue(s);
                s = s.substring(s.indexOf(encoding) + encoding.length() + 1).trim();
            } else if (state == 1 || state == 2) {
                if (s.startsWith("standalone")) {
                    standalone = XmlResolver.getAttValue(s = s.substring(10));
                    if (standalone.equals("yes") || standalone.equals("no")) break;
                    throw new KNXMLException("invalid standalone pseudo-attribute", standalone, 0);
                }
            } else {
                throw new KNXMLException("unknown XML declaration pseudo-attribute", s, 0);
            }
            ++state;
        }
        return new String[]{version, encoding, standalone};
    }

    private static String getAttValue(String s) throws KNXMLException {
        int end;
        String v;
        String att = s.trim();
        if (att.charAt(0) == '=' && att.length() > 2 && (v = att.substring(1).trim()).length() > 1 && (v.charAt(0) == '\'' || v.charAt(0) == '\"') && (end = v.indexOf(v.charAt(0), 1)) != -1) {
            return v.substring(1, end);
        }
        throw new KNXMLException("no pseudo-attribute value found", att, 0);
    }
}

