/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlWriter;

public final class XmlStreamWriterProxy
implements XmlWriter {
    final XMLStreamWriter w;
    private final Closeable close;

    public static XmlStreamWriterProxy createXmlStreamWriter(OutputStream stream, Closeable onClose) throws XMLStreamException, FactoryConfigurationError {
        return new XmlStreamWriterProxy(XMLOutputFactory.newInstance().createXMLStreamWriter(stream, StandardCharsets.UTF_8.name()), onClose);
    }

    public static XmlStreamWriterProxy createXmlStreamWriter(Writer stream) throws XMLStreamException, FactoryConfigurationError {
        return new XmlStreamWriterProxy(XMLOutputFactory.newInstance().createXMLStreamWriter(stream), () -> {});
    }

    XmlStreamWriterProxy(XMLStreamWriter writer, Closeable onClose) {
        this.w = writer;
        this.close = onClose;
    }

    @Override
    public void writeStartElement(String localName) {
        try {
            this.w.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeStartElement", e);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        try {
            this.w.writeStartElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeStartElement", e);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        try {
            this.w.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeStartElement", e);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        try {
            this.w.writeEmptyElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeEmptyElement", e);
        }
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        try {
            this.w.writeEmptyElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeEmptyElement", e);
        }
    }

    @Override
    public void writeEmptyElement(String localName) {
        try {
            this.w.writeEmptyElement(localName);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeEmptyElement", e);
        }
    }

    @Override
    public void writeEndElement() {
        try {
            this.w.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeEndElement", e);
        }
    }

    @Override
    public void writeEndDocument() {
        try {
            this.w.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeEndDocument", e);
        }
    }

    @Override
    public void close() {
        try {
            this.w.close();
            this.close.close();
        }
        catch (IOException | XMLStreamException exception) {}
    }

    @Override
    public void flush() {
        try {
            this.w.flush();
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("flush", e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) {
        try {
            this.w.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeAttribute", e);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        try {
            this.w.writeAttribute(prefix, namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeAttribute", e);
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        try {
            this.w.writeAttribute(namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeAttribute", e);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        try {
            this.w.writeNamespace(prefix, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeNamespace", e);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        try {
            this.w.writeDefaultNamespace(namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeDefaultNamespace", e);
        }
    }

    @Override
    public void writeComment(String data) {
        try {
            this.w.writeComment(data);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeComment", e);
        }
    }

    @Override
    public void writeProcessingInstruction(String target) {
        try {
            this.w.writeProcessingInstruction(target);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeProcessingInstruction", e);
        }
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        try {
            this.w.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeProcessingInstruction", e);
        }
    }

    @Override
    public void writeCData(String data) {
        try {
            this.w.writeCData(data);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeCData", e);
        }
    }

    @Override
    public void writeDTD(String dtd) {
        try {
            this.w.writeDTD(dtd);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeDTD", e);
        }
    }

    @Override
    public void writeEntityRef(String name) {
        try {
            this.w.writeEntityRef(name);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeEntityRef", e);
        }
    }

    @Override
    public void writeStartDocument() {
        try {
            this.w.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeStartDocument", e);
        }
    }

    @Override
    public void writeStartDocument(String version) {
        try {
            this.w.writeStartDocument(version);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeStartDocument", e);
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        try {
            this.w.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeStartDocument", e);
        }
    }

    @Override
    public void writeCharacters(String text) {
        try {
            this.w.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeCharacters", e);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        try {
            this.w.writeCharacters(text, start, len);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("writeCharacters", e);
        }
    }

    @Override
    public String getPrefix(String uri) {
        return null;
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        try {
            this.w.setPrefix(prefix, uri);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("setPrefix", e);
        }
    }

    @Override
    public void setDefaultNamespace(String uri) {
        try {
            this.w.setDefaultNamespace(uri);
        }
        catch (XMLStreamException e) {
            throw new KNXMLException("setDefaultNamespace", e);
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.w.getProperty(name);
    }
}

