/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    private int[] remappedVariableIndices = new int[40];
    private Object[] remappedLocalTypes = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;

    public LocalVariablesSorter(int access, String descriptor, MethodVisitor methodVisitor) {
        this(458752, access, descriptor, methodVisitor);
        if (((Object)((Object)this)).getClass() != LocalVariablesSorter.class) {
            throw new IllegalStateException();
        }
    }

    protected LocalVariablesSorter(int api, int access, String descriptor, MethodVisitor methodVisitor) {
        super(api, methodVisitor);
        this.nextLocal = (8 & access) == 0 ? 1 : 0;
        Type[] typeArray = Type.getArgumentTypes((String)descriptor);
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type argumentType = typeArray[n2];
            this.nextLocal += argumentType.getSize();
            ++n2;
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, this.remap(var, switch (opcode) {
            case 22, 55 -> Type.LONG_TYPE;
            case 24, 57 -> Type.DOUBLE_TYPE;
            case 23, 56 -> Type.FLOAT_TYPE;
            case 21, 54 -> Type.INT_TYPE;
            case 25, 58, 169 -> OBJECT_TYPE;
            default -> throw new IllegalArgumentException("Invalid opcode " + opcode);
        }));
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(this.remap(var, Type.INT_TYPE), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, this.nextLocal);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        int remappedIndex = this.remap(index, Type.getType((String)descriptor));
        super.visitLocalVariable(name, descriptor, signature, start, end, remappedIndex);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        Type type = Type.getType((String)descriptor);
        int[] remappedIndex = new int[index.length];
        int i = 0;
        while (i < remappedIndex.length) {
            remappedIndex[i] = this.remap(index[i], type);
            ++i;
        }
        return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, remappedIndex, descriptor, visible);
    }

    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalArgumentException("LocalVariablesSorter only accepts expanded frames (see ClassReader.EXPAND_FRAMES)");
        }
        Object[] oldRemappedLocals = new Object[this.remappedLocalTypes.length];
        System.arraycopy(this.remappedLocalTypes, 0, oldRemappedLocals, 0, oldRemappedLocals.length);
        this.updateNewLocals(this.remappedLocalTypes);
        int oldVar = 0;
        int i = 0;
        while (i < numLocal) {
            Object localType = local[i];
            if (localType != Opcodes.TOP) {
                Type varType = OBJECT_TYPE;
                if (localType == Opcodes.INTEGER) {
                    varType = Type.INT_TYPE;
                } else if (localType == Opcodes.FLOAT) {
                    varType = Type.FLOAT_TYPE;
                } else if (localType == Opcodes.LONG) {
                    varType = Type.LONG_TYPE;
                } else if (localType == Opcodes.DOUBLE) {
                    varType = Type.DOUBLE_TYPE;
                } else if (localType instanceof String) {
                    varType = Type.getObjectType((String)((String)localType));
                }
                this.setFrameLocal(this.remap(oldVar, varType), localType);
            }
            oldVar += localType == Opcodes.LONG || localType == Opcodes.DOUBLE ? 2 : 1;
            ++i;
        }
        oldVar = 0;
        int newVar = 0;
        int remappedNumLocal = 0;
        while (oldVar < this.remappedLocalTypes.length) {
            Object localType;
            oldVar += (localType = this.remappedLocalTypes[oldVar]) == Opcodes.LONG || localType == Opcodes.DOUBLE ? 2 : 1;
            if (localType != null && localType != Opcodes.TOP) {
                this.remappedLocalTypes[newVar++] = localType;
                remappedNumLocal = newVar;
                continue;
            }
            this.remappedLocalTypes[newVar++] = Opcodes.TOP;
        }
        super.visitFrame(type, remappedNumLocal, this.remappedLocalTypes, numStack, stack);
        this.remappedLocalTypes = oldRemappedLocals;
    }

    public int newLocal(Type type) {
        Object localType = switch (type.getSort()) {
            case 1, 2, 3, 4, 5 -> Opcodes.INTEGER;
            case 6 -> Opcodes.FLOAT;
            case 7 -> Opcodes.LONG;
            case 8 -> Opcodes.DOUBLE;
            case 9 -> type.getDescriptor();
            case 10 -> type.getInternalName();
            default -> throw new AssertionError();
        };
        int local = this.newLocalMapping(type);
        this.setLocalType(local, type);
        this.setFrameLocal(local, localType);
        return local;
    }

    protected void updateNewLocals(Object[] newLocals) {
    }

    protected void setLocalType(int local, Type type) {
    }

    private void setFrameLocal(int local, Object type) {
        int numLocals = this.remappedLocalTypes.length;
        if (local >= numLocals) {
            Object[] newRemappedLocalTypes = new Object[Math.max(2 * numLocals, local + 1)];
            System.arraycopy(this.remappedLocalTypes, 0, newRemappedLocalTypes, 0, numLocals);
            this.remappedLocalTypes = newRemappedLocalTypes;
        }
        this.remappedLocalTypes[local] = type;
    }

    private int remap(int var, Type type) {
        int value;
        int size;
        if (var + type.getSize() <= this.firstLocal) {
            return var;
        }
        int key = 2 * var + type.getSize() - 1;
        if (key >= (size = this.remappedVariableIndices.length)) {
            int[] newRemappedVariableIndices = new int[Math.max(2 * size, key + 1)];
            System.arraycopy(this.remappedVariableIndices, 0, newRemappedVariableIndices, 0, size);
            this.remappedVariableIndices = newRemappedVariableIndices;
        }
        if ((value = this.remappedVariableIndices[key]) == 0) {
            value = this.newLocalMapping(type);
            this.setLocalType(value, type);
            this.remappedVariableIndices[key] = value + 1;
        } else {
            --value;
        }
        return value;
    }

    protected int newLocalMapping(Type type) {
        int local = this.nextLocal;
        this.nextLocal += type.getSize();
        return local;
    }
}

