/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class SerialVersionUIDAdder
extends ClassVisitor {
    private static final String CLINIT = "<clinit>";
    private boolean computeSvuid;
    private boolean hasSvuid;
    private int access;
    private String name;
    private String[] interfaces;
    private Collection<Item> svuidFields;
    private boolean hasStaticInitializer;
    private Collection<Item> svuidConstructors;
    private Collection<Item> svuidMethods;

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        this(458752, classVisitor);
        if (((Object)((Object)this)).getClass() != SerialVersionUIDAdder.class) {
            throw new IllegalStateException();
        }
    }

    protected SerialVersionUIDAdder(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean bl = this.computeSvuid = (access & 0x4000) == 0;
        if (this.computeSvuid) {
            this.name = name;
            this.access = access;
            this.interfaces = new String[interfaces.length];
            this.svuidFields = new ArrayList<Item>();
            this.svuidConstructors = new ArrayList<Item>();
            this.svuidMethods = new ArrayList<Item>();
            System.arraycopy(interfaces, 0, this.interfaces, 0, interfaces.length);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.computeSvuid) {
            if (CLINIT.equals(name)) {
                this.hasStaticInitializer = true;
            }
            int mods = access & 0xD3F;
            if ((access & 2) == 0) {
                if ("<init>".equals(name)) {
                    this.svuidConstructors.add(new Item(name, mods, descriptor));
                } else if (!CLINIT.equals(name)) {
                    this.svuidMethods.add(new Item(name, mods, descriptor));
                }
            }
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.computeSvuid) {
            if ("serialVersionUID".equals(name)) {
                this.computeSvuid = false;
                this.hasSvuid = true;
            }
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                int mods = access & 0xDF;
                this.svuidFields.add(new Item(name, mods, desc));
            }
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String innerClassName, String outerName, String innerName, int innerClassAccess) {
        if (this.name != null && this.name.equals(innerClassName)) {
            this.access = innerClassAccess;
        }
        super.visitInnerClass(innerClassName, outerName, innerName, innerClassAccess);
    }

    public void visitEnd() {
        if (this.computeSvuid && !this.hasSvuid) {
            try {
                this.addSVUID(this.computeSVUID());
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while computing SVUID for " + this.name, e);
            }
        }
        super.visitEnd();
    }

    public boolean hasSVUID() {
        return this.hasSvuid;
    }

    protected void addSVUID(long svuid) {
        FieldVisitor fieldVisitor = super.visitField(24, "serialVersionUID", "J", null, (Object)svuid);
        if (fieldVisitor != null) {
            fieldVisitor.visitEnd();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long computeSVUID() throws IOException {
        long svuid = 0L;
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                    dataOutputStream.writeUTF(this.name.replace('/', '.'));
                    int mods = this.access;
                    if ((mods & 0x200) != 0) {
                        mods = this.svuidMethods.isEmpty() ? mods & 0xFFFFFBFF : mods | 0x400;
                    }
                    dataOutputStream.writeInt(mods & 0x611);
                    Arrays.sort(this.interfaces);
                    String[] stringArray = this.interfaces;
                    int n = this.interfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String interfaceName = stringArray[n2];
                        dataOutputStream.writeUTF(interfaceName.replace('/', '.'));
                        ++n2;
                    }
                    SerialVersionUIDAdder.writeItems(this.svuidFields, dataOutputStream, false);
                    if (this.hasStaticInitializer) {
                        dataOutputStream.writeUTF(CLINIT);
                        dataOutputStream.writeInt(8);
                        dataOutputStream.writeUTF("()V");
                    }
                    SerialVersionUIDAdder.writeItems(this.svuidConstructors, dataOutputStream, true);
                    SerialVersionUIDAdder.writeItems(this.svuidMethods, dataOutputStream, true);
                    dataOutputStream.flush();
                    byte[] hashBytes = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
                    int i = Math.min(hashBytes.length, 8) - 1;
                    while (i >= 0) {
                        svuid = svuid << 8 | (long)(hashBytes[i] & 0xFF);
                        --i;
                    }
                }
                if (byteArrayOutputStream == null) return svuid;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (byteArrayOutputStream == null) throw throwable;
                byteArrayOutputStream.close();
                throw throwable;
            }
            byteArrayOutputStream.close();
            return svuid;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected byte[] computeSHAdigest(byte[] value) {
        try {
            return MessageDigest.getInstance("SHA").digest(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static void writeItems(Collection<Item> itemCollection, DataOutput dataOutputStream, boolean dotted) throws IOException {
        Object[] items = itemCollection.toArray(new Item[0]);
        Arrays.sort(items);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            dataOutputStream.writeUTF(((Item)item).name);
            dataOutputStream.writeInt(((Item)item).access);
            dataOutputStream.writeUTF(dotted ? ((Item)item).descriptor.replace('/', '.') : ((Item)item).descriptor);
            ++n2;
        }
    }

    private static final class Item
    implements Comparable<Item> {
        final String name;
        final int access;
        final String descriptor;

        Item(String name, int access, String descriptor) {
            this.name = name;
            this.access = access;
            this.descriptor = descriptor;
        }

        @Override
        public int compareTo(Item item) {
            int result = this.name.compareTo(item.name);
            if (result == 0) {
                result = this.descriptor.compareTo(item.descriptor);
            }
            return result;
        }

        public boolean equals(Object other) {
            if (other instanceof Item) {
                return this.compareTo((Item)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.descriptor.hashCode();
        }
    }
}

