/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.check;

import org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long[][] TABLE = new long[4][256];
    private long crc = -1L;

    static {
        int s = 0;
        while (s < 4) {
            int b = 0;
            while (b < 256) {
                long r = s == 0 ? (long)b : TABLE[s - 1][b];
                int i = 0;
                while (i < 8) {
                    r = (r & 1L) == 1L ? r >>> 1 ^ 0xC96C5795D7870F42L : (r >>>= 1);
                    ++i;
                }
                CRC64.TABLE[s][b] = r;
                ++b;
            }
            ++s;
        }
    }

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        int end = off + len;
        int i = off;
        int end4 = end - 3;
        while (i < end4) {
            int tmp = (int)this.crc;
            this.crc = TABLE[3][tmp & 0xFF ^ buf[i] & 0xFF] ^ TABLE[2][tmp >>> 8 & 0xFF ^ buf[i + 1] & 0xFF] ^ this.crc >>> 32 ^ TABLE[1][tmp >>> 16 & 0xFF ^ buf[i + 2] & 0xFF] ^ TABLE[0][tmp >>> 24 & 0xFF ^ buf[i + 3] & 0xFF];
            i += 4;
        }
        while (i < end) {
            this.crc = TABLE[0][buf[i++] & 0xFF ^ (int)this.crc & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long value = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] buf = new byte[8];
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)(value >> i * 8);
            ++i;
        }
        return buf;
    }
}

