/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.usb.UsbClaimException;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbPlatformException;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.DefaultUsbControlIrp;
import org.usb4java.ConfigDescriptor;
import org.usb4java.Device;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.javax.Configuration;
import org.usb4java.javax.ControlIrpQueue;
import org.usb4java.javax.DeviceId;
import org.usb4java.javax.DeviceListenerList;
import org.usb4java.javax.DeviceManager;
import org.usb4java.javax.ExceptionUtils;
import org.usb4java.javax.Hub;
import org.usb4java.javax.Services;
import org.usb4java.javax.descriptors.SimpleUsbStringDescriptor;

abstract class AbstractDevice
implements UsbDevice {
    private final DeviceManager manager;
    private final DeviceId id;
    private final DeviceId parentId;
    private final int speed;
    private List<Configuration> configurations;
    private Map<Byte, Configuration> configMapping = new HashMap<Byte, Configuration>();
    private final DeviceListenerList listeners = new DeviceListenerList();
    private DeviceHandle handle;
    private byte activeConfigurationNumber = 0;
    private Set<Byte> claimedInterfaceNumbers = new HashSet<Byte>();
    private UsbPort port;
    private final ControlIrpQueue queue = new ControlIrpQueue(this, this.listeners);
    private boolean detachedKernelDriver;

    AbstractDevice(DeviceManager manager, DeviceId id, DeviceId parentId, int speed, Device device) throws UsbPlatformException {
        if (manager == null) {
            throw new IllegalArgumentException("manager must be set");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must be set");
        }
        this.manager = manager;
        this.id = id;
        this.parentId = parentId;
        this.speed = speed;
        int numConfigurations = id.getDeviceDescriptor().bNumConfigurations() & 0xFF;
        ArrayList<Configuration> configurations = new ArrayList<Configuration>(numConfigurations);
        int i = 0;
        while (i < numConfigurations) {
            ConfigDescriptor configDescriptor = new ConfigDescriptor();
            int result = LibUsb.getConfigDescriptor((Device)device, (byte)((byte)i), (ConfigDescriptor)configDescriptor);
            if (result < 0) {
                throw ExceptionUtils.createPlatformException("Unable to get configuration " + i + " for device " + id, result);
            }
            try {
                Configuration config = new Configuration(this, configDescriptor);
                configurations.add(config);
                this.configMapping.put(configDescriptor.bConfigurationValue(), config);
            }
            finally {
                LibUsb.freeConfigDescriptor((ConfigDescriptor)configDescriptor);
            }
            ++i;
        }
        this.configurations = Collections.unmodifiableList(configurations);
        ConfigDescriptor configDescriptor = new ConfigDescriptor();
        int result = LibUsb.getActiveConfigDescriptor((Device)device, (ConfigDescriptor)configDescriptor);
        if (result == -5 || result == -2) {
            this.activeConfigurationNumber = 0;
        } else {
            if (result < 0) {
                throw ExceptionUtils.createPlatformException("Unable to read active config descriptor from device " + id, result);
            }
            this.activeConfigurationNumber = configDescriptor.bConfigurationValue();
            LibUsb.freeConfigDescriptor((ConfigDescriptor)configDescriptor);
        }
    }

    public final DeviceId getId() {
        return this.id;
    }

    public final DeviceId getParentId() {
        return this.parentId;
    }

    final void checkConnected() {
        if (this.port == null) {
            throw new UsbDisconnectedException();
        }
    }

    public final DeviceHandle open() throws UsbException {
        if (this.handle == null) {
            Device device = this.manager.getLibUsbDevice(this.id);
            try {
                DeviceHandle handle = new DeviceHandle();
                int result = LibUsb.open((Device)device, (DeviceHandle)handle);
                if (result < 0) {
                    throw ExceptionUtils.createPlatformException("Can't open device " + this.id, result);
                }
                this.handle = handle;
            }
            finally {
                this.manager.releaseDevice(device);
            }
        }
        return this.handle;
    }

    public final void close() {
        if (this.handle != null) {
            LibUsb.close((DeviceHandle)this.handle);
            this.handle = null;
        }
    }

    public final UsbPort getParentUsbPort() {
        this.checkConnected();
        return this.port;
    }

    final void setParentUsbPort(UsbPort port) {
        if (this.port == null && port == null) {
            throw new IllegalStateException("Device already detached");
        }
        if (this.port != null && port != null) {
            throw new IllegalStateException("Device already attached");
        }
        if (port == null && this.isUsbHub()) {
            Hub hub = (Hub)this;
            for (AbstractDevice device : hub.getAttachedUsbDevices()) {
                hub.disconnectUsbDevice(device);
            }
        }
        this.port = port;
        Services services = Services.getInstance();
        if (port == null) {
            this.listeners.usbDeviceDetached(new UsbDeviceEvent((UsbDevice)this));
            services.usbDeviceDetached(this);
        } else {
            services.usbDeviceAttached(this);
        }
    }

    public final String getManufacturerString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte index = this.getUsbDeviceDescriptor().iManufacturer();
        if (index == 0) {
            return null;
        }
        return this.getString(index);
    }

    public final String getSerialNumberString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte index = this.getUsbDeviceDescriptor().iSerialNumber();
        if (index == 0) {
            return null;
        }
        return this.getString(index);
    }

    public final String getProductString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte index = this.getUsbDeviceDescriptor().iProduct();
        if (index == 0) {
            return null;
        }
        return this.getString(index);
    }

    public final Object getSpeed() {
        switch (this.speed) {
            case 2: {
                return UsbConst.DEVICE_SPEED_FULL;
            }
            case 1: {
                return UsbConst.DEVICE_SPEED_LOW;
            }
        }
        return UsbConst.DEVICE_SPEED_UNKNOWN;
    }

    public final List<Configuration> getUsbConfigurations() {
        return this.configurations;
    }

    public final Configuration getUsbConfiguration(byte number) {
        return this.configMapping.get(number);
    }

    public final boolean containsUsbConfiguration(byte number) {
        return this.configMapping.containsKey(number);
    }

    public final byte getActiveUsbConfigurationNumber() {
        return this.activeConfigurationNumber;
    }

    final void setActiveUsbConfigurationNumber(byte number) throws UsbException {
        if (number != this.activeConfigurationNumber) {
            if (!this.claimedInterfaceNumbers.isEmpty()) {
                throw new UsbException("Can't change configuration while an interface is still claimed");
            }
            int result = LibUsb.setConfiguration((DeviceHandle)this.open(), (int)(number & 0xFF));
            if (result < 0) {
                throw ExceptionUtils.createPlatformException("Unable to set configuration", result);
            }
            this.activeConfigurationNumber = number;
        }
    }

    final void claimInterface(byte number, boolean force) throws UsbException {
        int result;
        if (this.claimedInterfaceNumbers.contains(number)) {
            throw new UsbClaimException("An interface is already claimed");
        }
        DeviceHandle handle = this.open();
        if (force) {
            result = LibUsb.kernelDriverActive((DeviceHandle)handle, (int)number);
            if (result == -4) {
                throw new UsbDisconnectedException();
            }
            if (result == 1) {
                result = LibUsb.detachKernelDriver((DeviceHandle)handle, (int)number);
                if (result < 0) {
                    throw ExceptionUtils.createPlatformException("Unable to detach kernel driver", result);
                }
                this.detachedKernelDriver = true;
            }
        }
        if ((result = LibUsb.claimInterface((DeviceHandle)handle, (int)(number & 0xFF))) < 0) {
            throw ExceptionUtils.createPlatformException("Unable to claim interface", result);
        }
        this.claimedInterfaceNumbers.add(number);
    }

    final void releaseInterface(byte number) throws UsbException {
        if (this.claimedInterfaceNumbers.isEmpty()) {
            throw new UsbClaimException("No interface is claimed");
        }
        if (!this.claimedInterfaceNumbers.contains(number)) {
            throw new UsbClaimException("Interface not claimed");
        }
        DeviceHandle handle = this.open();
        int result = LibUsb.releaseInterface((DeviceHandle)handle, (int)(number & 0xFF));
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to release interface", result);
        }
        if (this.detachedKernelDriver && (result = LibUsb.attachKernelDriver((DeviceHandle)handle, (int)(number & 0xFF))) < 0) {
            throw ExceptionUtils.createPlatformException("Unable to re-attach kernel driver", result);
        }
        this.claimedInterfaceNumbers.remove(number);
    }

    final boolean isInterfaceClaimed(byte number) {
        return this.claimedInterfaceNumbers.contains(number);
    }

    public final Configuration getActiveUsbConfiguration() {
        return this.getUsbConfiguration(this.getActiveUsbConfigurationNumber());
    }

    public final boolean isConfigured() {
        return this.getActiveUsbConfigurationNumber() != 0;
    }

    public final UsbDeviceDescriptor getUsbDeviceDescriptor() {
        return this.id.getDeviceDescriptor();
    }

    public final UsbStringDescriptor getUsbStringDescriptor(byte index) throws UsbException {
        this.checkConnected();
        short[] languages = this.getLanguages();
        DeviceHandle handle = this.open();
        short langId = languages.length == 0 ? (short)0 : languages[0];
        ByteBuffer data = ByteBuffer.allocateDirect(256);
        int result = LibUsb.getStringDescriptor((DeviceHandle)handle, (byte)index, (short)langId, (ByteBuffer)data);
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to get string descriptor " + index + " from device " + this, result);
        }
        return new SimpleUsbStringDescriptor(data);
    }

    public final String getString(byte index) throws UsbException, UnsupportedEncodingException {
        return this.getUsbStringDescriptor(index).getString();
    }

    private short[] getLanguages() throws UsbException {
        ByteBuffer buffer;
        DeviceHandle handle = this.open();
        int result = LibUsb.getDescriptor((DeviceHandle)handle, (byte)3, (byte)0, (ByteBuffer)(buffer = ByteBuffer.allocateDirect(256)));
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to get string descriptor languages", result);
        }
        if (result < 2) {
            throw new UsbException("Received illegal descriptor length: " + result);
        }
        short[] languages = new short[(result - 2) / 2];
        if (languages.length == 0) {
            return languages;
        }
        buffer.position(2);
        buffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(languages);
        return languages;
    }

    public final void syncSubmit(UsbControlIrp irp) throws UsbException {
        if (irp == null) {
            throw new IllegalArgumentException("irp must not be null");
        }
        this.checkConnected();
        this.queue.add(irp);
        irp.waitUntilComplete();
        if (irp.isUsbException()) {
            throw irp.getUsbException();
        }
    }

    public final void asyncSubmit(UsbControlIrp irp) {
        if (irp == null) {
            throw new IllegalArgumentException("irp must not be null");
        }
        this.checkConnected();
        this.queue.add(irp);
    }

    public final void syncSubmit(List list) throws UsbException {
        if (list == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.checkConnected();
        for (Object item : list) {
            if (!(item instanceof UsbControlIrp)) {
                throw new IllegalArgumentException("List contains non-UsbControlIrp objects");
            }
            this.syncSubmit((UsbControlIrp)item);
        }
    }

    public final void asyncSubmit(List list) {
        if (list == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.checkConnected();
        for (Object item : list) {
            if (!(item instanceof UsbControlIrp)) {
                throw new IllegalArgumentException("List contains non-UsbControlIrp objects");
            }
            this.asyncSubmit((UsbControlIrp)item);
        }
    }

    public final UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new DefaultUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
    }

    public final void addUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.add(listener);
    }

    public final void removeUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.remove(listener);
    }

    public final String toString() {
        return this.id.toString();
    }
}

