/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.usb.UsbControlIrp;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbShortPacketException;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.Config;
import org.usb4java.javax.ExceptionUtils;
import org.usb4java.javax.Services;

abstract class AbstractIrpQueue<T extends UsbIrp> {
    private final Queue<T> irps = new ConcurrentLinkedQueue<T>();
    private volatile Thread processor;
    private volatile boolean aborting;
    private final AbstractDevice device;

    AbstractIrpQueue(AbstractDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("device must be set");
        }
        this.device = device;
    }

    public final void add(T irp) {
        this.irps.add(irp);
        if (this.processor == null) {
            this.processor = new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractIrpQueue.this.process();
                }
            });
            this.processor.setDaemon(true);
            this.processor.setName("usb4java IRP Queue Processor");
            this.processor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void process() {
        block7: {
            irp = (UsbIrp)this.irps.poll();
            if (irp != null) ** GOTO lbl16
            this.processor = null;
            break block7;
lbl-1000:
            // 1 sources

            {
                try {
                    this.processIrp(irp);
                }
                catch (UsbException e) {
                    irp.setUsbException(e);
                }
                nextIrp = (UsbIrp)this.irps.poll();
                if (nextIrp == null) {
                    this.processor = null;
                }
                irp.complete();
                this.finishIrp(irp);
                irp = nextIrp;
lbl16:
                // 2 sources

                ** while (irp != null)
            }
        }
        var2_2 = this.irps;
        synchronized (var2_2) {
            this.irps.notifyAll();
        }
    }

    protected abstract void processIrp(T var1) throws UsbException;

    protected abstract void finishIrp(UsbIrp var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() {
        this.aborting = true;
        this.irps.clear();
        while (this.isBusy()) {
            try {
                Queue<T> queue = this.irps;
                synchronized (queue) {
                    if (this.isBusy()) {
                        this.irps.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.aborting = false;
    }

    public final boolean isBusy() {
        return !this.irps.isEmpty() || this.processor != null;
    }

    protected final Config getConfig() {
        return Services.getInstance().getConfig();
    }

    protected final AbstractDevice getDevice() {
        return this.device;
    }

    protected final void processControlIrp(UsbControlIrp irp) throws UsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(irp.getLength());
        buffer.put(irp.getData(), irp.getOffset(), irp.getLength());
        buffer.rewind();
        DeviceHandle handle = this.getDevice().open();
        int result = LibUsb.controlTransfer((DeviceHandle)handle, (byte)irp.bmRequestType(), (byte)irp.bRequest(), (short)irp.wValue(), (short)irp.wIndex(), (ByteBuffer)buffer, (long)this.getConfig().getTimeout());
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to submit control message", result);
        }
        buffer.rewind();
        buffer.get(irp.getData(), irp.getOffset(), result);
        irp.setActualLength(result);
        if (irp.getActualLength() != irp.getLength() && !irp.getAcceptShortPacket()) {
            throw new UsbShortPacketException();
        }
    }

    protected final boolean isAborting() {
        return this.aborting;
    }
}

