/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.usb.UsbAbortException;
import javax.usb.UsbControlIrp;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbShortPacketException;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.javax.AbstractIrpQueue;
import org.usb4java.javax.Endpoint;
import org.usb4java.javax.ExceptionUtils;
import org.usb4java.javax.Pipe;

final class IrpQueue
extends AbstractIrpQueue<UsbIrp> {
    private final Pipe pipe;

    IrpQueue(Pipe pipe) {
        super(pipe.getDevice());
        this.pipe = pipe;
    }

    @Override
    protected void finishIrp(UsbIrp irp) {
        this.pipe.sendEvent(irp);
    }

    @Override
    protected void processIrp(UsbIrp irp) throws UsbException {
        Endpoint endpoint = this.pipe.getUsbEndpoint();
        byte direction = endpoint.getDirection();
        byte type = endpoint.getType();
        if (type == 0) {
            this.processControlIrp((UsbControlIrp)irp);
            return;
        }
        switch (direction) {
            case 0: {
                irp.setActualLength(this.write(irp.getData(), irp.getOffset(), irp.getLength()));
                if (irp.getActualLength() >= irp.getLength() || irp.getAcceptShortPacket()) break;
                throw new UsbShortPacketException();
            }
            case -128: {
                irp.setActualLength(this.read(irp.getData(), irp.getOffset(), irp.getLength()));
                if (irp.getActualLength() >= irp.getLength() || irp.getAcceptShortPacket()) break;
                throw new UsbShortPacketException();
            }
            default: {
                throw new UsbException("Invalid direction: " + direction);
            }
        }
    }

    private UsbEndpointDescriptor getEndpointDescriptor() {
        return this.pipe.getUsbEndpoint().getUsbEndpointDescriptor();
    }

    private int read(byte[] data, int offset, int len) throws UsbException {
        UsbEndpointDescriptor descriptor = this.getEndpointDescriptor();
        byte type = this.pipe.getUsbEndpoint().getType();
        DeviceHandle handle = this.getDevice().open();
        int read = 0;
        while (read < len) {
            int size = Math.min(len - read, descriptor.wMaxPacketSize() & 0xFFFF);
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            int result = this.transfer(handle, descriptor, type, buffer);
            buffer.rewind();
            buffer.get(data, offset + read, result);
            read += result;
            if (result < size) break;
        }
        return read;
    }

    private int write(byte[] data, int offset, int len) throws UsbException {
        UsbEndpointDescriptor descriptor = this.getEndpointDescriptor();
        byte type = this.pipe.getUsbEndpoint().getType();
        DeviceHandle handle = this.getDevice().open();
        int written = 0;
        while (written < len) {
            int size = Math.min(len - written, descriptor.wMaxPacketSize() & 0xFFFF);
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buffer.put(data, offset + written, size);
            buffer.rewind();
            int result = this.transfer(handle, descriptor, type, buffer);
            written += result;
            if (result < size) break;
        }
        return written;
    }

    private int transfer(DeviceHandle handle, UsbEndpointDescriptor descriptor, int type, ByteBuffer buffer) throws UsbException {
        boolean in;
        byte address = descriptor.bEndpointAddress();
        boolean bl = in = this.pipe.getUsbEndpoint().getDirection() == -128;
        if (type == 2) {
            return this.transferBulk(handle, address, in, buffer);
        }
        if (type == 3) {
            return this.transferInterrupt(handle, address, in, buffer);
        }
        throw new UsbException("Unsupported endpoint type: " + type);
    }

    private int transferBulk(DeviceHandle handle, byte address, boolean in, ByteBuffer buffer) throws UsbException {
        int result;
        IntBuffer transferred = IntBuffer.allocate(1);
        do {
            if ((result = LibUsb.bulkTransfer((DeviceHandle)handle, (byte)address, (ByteBuffer)buffer, (IntBuffer)transferred, (long)this.getConfig().getTimeout())) != -7 || !this.isAborting()) continue;
            throw new UsbAbortException();
        } while (in && result == -7);
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Transfer error on bulk endpoint", result);
        }
        return transferred.get(0);
    }

    private int transferInterrupt(DeviceHandle handle, byte address, boolean in, ByteBuffer buffer) throws UsbException {
        int result;
        IntBuffer transferred = IntBuffer.allocate(1);
        do {
            if ((result = LibUsb.interruptTransfer((DeviceHandle)handle, (byte)address, (ByteBuffer)buffer, (IntBuffer)transferred, (long)this.getConfig().getTimeout())) != -7 || !this.isAborting()) continue;
            throw new UsbAbortException();
        } while (in && result == -7);
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Transfer error on interrupt endpoint", result);
        }
        return transferred.get(0);
    }
}

